/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.dmg.pmml.Model;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.compiler.api.provider.ModelImplementationProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelImplementationProviderFinderImpl
implements ModelImplementationProviderFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)ModelImplementationProviderFinderImpl.class.getName());
    private ServiceLoader<ModelImplementationProvider> loader = ServiceLoader.load(ModelImplementationProvider.class);

    public <T extends Model, E extends KiePMMLModel> List<ModelImplementationProvider<T, E>> getImplementations(boolean refresh) {
        logger.debug("getImplementations {}", (Object)refresh);
        ArrayList<ModelImplementationProvider<ModelImplementationProvider, E>> toReturn = new ArrayList<ModelImplementationProvider<ModelImplementationProvider, E>>();
        Iterator<ModelImplementationProvider> providers = this.getProviders(refresh);
        providers.forEachRemaining(toReturn::add);
        logger.debug("toReturn {} {}", toReturn, (Object)toReturn.size());
        if (logger.isTraceEnabled()) {
            toReturn.forEach(provider -> logger.trace("{} : {}", (Object)provider.getPMMLModelType(), provider));
        }
        return toReturn;
    }

    private Iterator<ModelImplementationProvider> getProviders(boolean refresh) {
        if (refresh) {
            this.loader.reload();
        }
        return this.loader.iterator();
    }
}

