/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RegistryImage {
    private final ImageReference imageReference;
    private final List<CredentialRetriever> credentialRetrievers = new ArrayList<CredentialRetriever>();

    public static RegistryImage named(ImageReference imageReference) {
        return new RegistryImage(imageReference);
    }

    public static RegistryImage named(String imageReference) throws InvalidImageReferenceException {
        return RegistryImage.named(ImageReference.parse(imageReference));
    }

    private RegistryImage(ImageReference imageReference) {
        this.imageReference = imageReference;
    }

    public RegistryImage addCredential(String username, String password) {
        this.addCredentialRetriever(() -> Optional.of(Credential.from(username, password)));
        return this;
    }

    public RegistryImage addCredentialRetriever(CredentialRetriever credentialRetriever) {
        this.credentialRetrievers.add(credentialRetriever);
        return this;
    }

    ImageReference getImageReference() {
        return this.imageReference;
    }

    List<CredentialRetriever> getCredentialRetrievers() {
        return this.credentialRetrievers;
    }
}

