/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public interface BuildableManifestTemplate
extends ManifestTemplate {
    @Override
    public String getManifestMediaType();

    @Nullable
    public ContentDescriptorTemplate getContainerConfiguration();

    public List<ContentDescriptorTemplate> getLayers();

    public void setContainerConfiguration(long var1, DescriptorDigest var3);

    public void addLayer(long var1, DescriptorDigest var3);

    @VisibleForTesting
    public static class ContentDescriptorTemplate
    implements JsonTemplate {
        @Nullable
        private String mediaType;
        @Nullable
        private DescriptorDigest digest;
        private long size;
        @Nullable
        private List<String> urls;
        @Nullable
        private Map<String, String> annotations;

        ContentDescriptorTemplate(String mediaType, long size, DescriptorDigest digest) {
            this.mediaType = mediaType;
            this.size = size;
            this.digest = digest;
        }

        private ContentDescriptorTemplate() {
        }

        @VisibleForTesting
        public long getSize() {
            return this.size;
        }

        void setSize(long size) {
            this.size = size;
        }

        @Nullable
        @VisibleForTesting
        public DescriptorDigest getDigest() {
            return this.digest;
        }

        void setDigest(DescriptorDigest digest) {
            this.digest = digest;
        }

        @Nullable
        @VisibleForTesting
        public List<String> getUrls() {
            return this.urls;
        }

        void setUrls(List<String> urls) {
            this.urls = ImmutableList.copyOf(urls);
        }

        @Nullable
        @VisibleForTesting
        public Map<String, String> getAnnotations() {
            return this.annotations;
        }

        void setAnnotations(Map<String, String> annotations) {
            this.annotations = ImmutableMap.copyOf(annotations);
        }
    }
}

