/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.dto;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.AbstractSpecificCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;

public class MiningModelCompilationDTO
extends AbstractSpecificCompilationDTO<MiningModel> {
    public static final String SEGMENTATIONNAME_TEMPLATE = "%s_Segmentation";
    private static final long serialVersionUID = 3752088252358264261L;
    private final String segmentationName;
    private final String segmentationPackageName;
    private final String segmentationClassName;
    private final String segmentationCanonicalClassName;
    private final Segmentation segmentation;

    private MiningModelCompilationDTO(CompilationDTO<MiningModel> source) {
        super(source);
        this.segmentationName = String.format(SEGMENTATIONNAME_TEMPLATE, source.getModelName());
        this.segmentationPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)(this.getPackageName() + "." + this.segmentationName));
        this.segmentationClassName = KiePMMLModelUtils.getSanitizedClassName((String)this.segmentationName);
        this.segmentationCanonicalClassName = String.format("%s.%s", this.segmentationPackageName, this.segmentationClassName);
        this.segmentation = ((MiningModel)source.getModel()).getSegmentation();
    }

    public static MiningModelCompilationDTO fromCompilationDTO(CompilationDTO<MiningModel> source) {
        return new MiningModelCompilationDTO(source);
    }

    public String getSegmentationName() {
        return this.segmentationName;
    }

    public String getSegmentationPackageName() {
        return this.segmentationPackageName;
    }

    public String getSegmentationClassName() {
        return this.segmentationClassName;
    }

    public String getSegmentationCanonicalClassName() {
        return this.segmentationCanonicalClassName;
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public List<Segment> getSegments() {
        return this.segmentation != null ? this.segmentation.getSegments() : Collections.emptyList();
    }
}

