/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.IntSparseArray;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.NumberInterner;

public class IntegerInterner
extends NumberInterner<Integer> {
    private static final ConcurrentMap<Integer, Integer> cache = new ConcurrentHashMap<Integer, Integer>();
    public static final ThreadLocal<ConcurrentMap<Integer, Integer>> CACHE_PROVIDER = new ThreadLocal<ConcurrentMap<Integer, Integer>>(){

        @Override
        public ConcurrentMap<Integer, Integer> initialValue() {
            return cache;
        }
    };

    public IntegerInterner() {
        super(Integer.class, CACHE_PROVIDER.get());
    }

    @Override
    public Integer canonicalize(Integer value) {
        return (int)value;
    }

    @Override
    public VisitorAction visit(IntSparseArray intSparseArray) {
        if (intSparseArray.hasEntries()) {
            this.internAll(intSparseArray.getEntries());
        }
        if (intSparseArray.hasIndices()) {
            this.internAll(intSparseArray.getIndices());
        }
        return super.visit(intSparseArray);
    }

    @Override
    public VisitorAction visit(RealSparseArray realSparseArray) {
        if (realSparseArray.hasIndices()) {
            this.internAll(realSparseArray.getIndices());
        }
        return super.visit(realSparseArray);
    }

    public static void clear() {
        cache.clear();
    }
}

