/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public abstract class AbstractWaitStrategy
implements WaitStrategy {
    private static final RateLimiter DOCKER_CLIENT_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();
    protected WaitStrategyTarget waitStrategyTarget;
    @NonNull
    protected Duration startupTimeout = Duration.ofSeconds(60L);
    @NonNull
    private RateLimiter rateLimiter = DOCKER_CLIENT_RATE_LIMITER;

    @Override
    public void waitUntilReady(WaitStrategyTarget waitStrategyTarget) {
        this.waitStrategyTarget = waitStrategyTarget;
        this.waitUntilReady();
    }

    protected abstract void waitUntilReady();

    @Override
    public WaitStrategy withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return this;
    }

    protected Set<Integer> getLivenessCheckPorts() {
        return this.waitStrategyTarget.getLivenessCheckPortNumbers();
    }

    protected RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public WaitStrategy withRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }
}

