/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.http.SimpleHttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

public final class SimpleHttpClient {
    private final VertxInternal vertx;
    private final HttpClient client;
    private final String userAgent;

    public SimpleHttpClient(Vertx vertx, String userAgent, HttpClientOptions options) {
        this.vertx = (VertxInternal)vertx;
        this.client = vertx.createHttpClient(options);
        this.userAgent = userAgent;
    }

    public Future<SimpleHttpResponse> fetch(HttpMethod method, String url, JsonObject headers, Buffer payload) {
        PromiseInternal promise = this.vertx.promise();
        if (url == null || url.length() == 0) {
            promise.fail("Invalid url");
            return promise.future();
        }
        RequestOptions options = new RequestOptions().setMethod(method).setAbsoluteURI(url);
        if (this.userAgent != null) {
            options.addHeader("User-Agent", this.userAgent);
        }
        if (headers != null) {
            for (Map.Entry kv : headers) {
                options.addHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        this.makeRequest(options, payload, (Handler<AsyncResult<SimpleHttpResponse>>)promise);
        return promise.future();
    }

    public SimpleHttpClient fetch(HttpMethod method, String url, JsonObject headers, Buffer payload, Handler<AsyncResult<SimpleHttpResponse>> callback) {
        this.fetch(method, url, headers, payload).onComplete(callback);
        return this;
    }

    public static Buffer jsonToQuery(JsonObject json) {
        Buffer buffer = Buffer.buffer();
        try {
            for (Map.Entry kv : json) {
                if (buffer.length() != 0) {
                    buffer.appendByte((byte)38);
                }
                buffer.appendString(URLEncoder.encode((String)kv.getKey(), "UTF-8"));
                buffer.appendByte((byte)61);
                Object v = kv.getValue();
                if (v == null) continue;
                buffer.appendString(URLEncoder.encode(v.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public static JsonObject queryToJson(Buffer query) throws UnsupportedEncodingException {
        String[] pairs;
        if (query == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        for (String pair : pairs = query.toString().split("&")) {
            JsonArray array;
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            if (!json.containsKey(key)) {
                json.put(key, value);
                continue;
            }
            Object oldValue = json.getValue(key);
            if (oldValue instanceof JsonArray) {
                array = (JsonArray)oldValue;
            } else {
                array = new JsonArray();
                array.add(oldValue);
                json.put(key, (Object)array);
            }
            if (value == null) {
                array.addNull();
                continue;
            }
            array.add((Object)value);
        }
        return json;
    }

    private void makeRequest(RequestOptions options, Buffer payload, Handler<AsyncResult<SimpleHttpResponse>> callback) {
        this.client.request(options, request -> {
            if (request.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)request.cause()));
                return;
            }
            HttpClientRequest req = (HttpClientRequest)request.result();
            Handler resultHandler = send -> {
                if (send.failed()) {
                    callback.handle((Object)Future.failedFuture((Throwable)send.cause()));
                    return;
                }
                HttpClientResponse res = (HttpClientResponse)send.result();
                res.body(body -> {
                    if (body.succeeded()) {
                        Buffer value = (Buffer)body.result();
                        if (res.statusCode() < 200 || res.statusCode() >= 300) {
                            if (value == null || value.length() == 0) {
                                callback.handle((Object)Future.failedFuture((String)res.statusMessage()));
                            } else {
                                callback.handle((Object)Future.failedFuture((String)(res.statusMessage() + ": " + value.toString())));
                            }
                        } else {
                            callback.handle((Object)Future.succeededFuture((Object)new SimpleHttpResponse(res.statusCode(), res.headers(), value)));
                        }
                    } else {
                        callback.handle((Object)Future.failedFuture((Throwable)body.cause()));
                    }
                });
            };
            if (payload != null) {
                req.send(payload, resultHandler);
            } else {
                req.send(resultHandler);
            }
        });
    }
}

