/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event.progress;

import com.google.cloud.tools.jib.event.progress.Allocation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

class AllocationCompletionTracker {
    private final ConcurrentHashMap<Allocation, IndexedRemainingUnits> completionMap = new ConcurrentHashMap();

    AllocationCompletionTracker() {
    }

    boolean updateProgress(Allocation allocation, long units) {
        AtomicBoolean mapUpdated = new AtomicBoolean(units != 0L);
        this.completionMap.compute(allocation, (ignored, indexedRemainingUnits) -> {
            if (indexedRemainingUnits == null) {
                indexedRemainingUnits = new IndexedRemainingUnits(allocation);
                mapUpdated.set(true);
            }
            if (units != 0L) {
                this.updateIndexedRemainingUnits((IndexedRemainingUnits)indexedRemainingUnits, units);
            }
            return indexedRemainingUnits;
        });
        return mapUpdated.get();
    }

    @VisibleForTesting
    List<Allocation> getUnfinishedAllocations() {
        return this.completionMap.values().stream().filter(rec$ -> ((IndexedRemainingUnits)rec$).isUnfinished()).sorted().map(remainingUnits -> ((IndexedRemainingUnits)remainingUnits).allocation).collect(Collectors.toList());
    }

    private void updateIndexedRemainingUnits(IndexedRemainingUnits indexedRemainingUnits, long units) {
        Allocation allocation = indexedRemainingUnits.allocation;
        long newUnits = indexedRemainingUnits.remainingUnits.addAndGet(-units);
        if (newUnits < 0L) {
            throw new IllegalStateException("Progress exceeds max for '" + allocation.getDescription() + "': " + -newUnits + " more beyond " + allocation.getAllocationUnits());
        }
        if (newUnits == 0L) {
            allocation.getParent().ifPresent(parentAllocation -> this.updateIndexedRemainingUnits((IndexedRemainingUnits)Preconditions.checkNotNull((Object)this.completionMap.get(parentAllocation)), 1L));
        }
    }

    ImmutableList<String> getUnfinishedLeafTasks() {
        List<Allocation> allUnfinished = this.getUnfinishedAllocations();
        LinkedHashSet<Allocation> unfinishedLeaves = new LinkedHashSet<Allocation>(allUnfinished);
        for (Allocation allocation : allUnfinished) {
            Optional<Allocation> parent = allocation.getParent();
            while (parent.isPresent()) {
                unfinishedLeaves.remove(parent.get());
                parent = parent.get().getParent();
            }
        }
        return ImmutableList.copyOf((Collection)unfinishedLeaves.stream().map(Allocation::getDescription).collect(Collectors.toList()));
    }

    private static class IndexedRemainingUnits
    implements Comparable<IndexedRemainingUnits> {
        private static final AtomicInteger currentIndex = new AtomicInteger();
        private final int index = currentIndex.getAndIncrement();
        private final AtomicLong remainingUnits;
        private final Allocation allocation;

        private IndexedRemainingUnits(Allocation allocation) {
            this.allocation = allocation;
            this.remainingUnits = new AtomicLong(allocation.getAllocationUnits());
        }

        private boolean isUnfinished() {
            return this.remainingUnits.get() != 0L;
        }

        @Override
        public int compareTo(IndexedRemainingUnits otherIndexedRemainingUnits) {
            return this.index - otherIndexedRemainingUnits.index;
        }
    }
}

