/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.api.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.http.ResponseException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

class AuthenticationMethodRetriever
implements RegistryEndpointProvider<Optional<RegistryAuthenticator>> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    @Nullable
    private final String userAgent;
    private final FailoverHttpClient httpClient;

    AuthenticationMethodRetriever(RegistryEndpointRequestProperties registryEndpointRequestProperties, @Nullable String userAgent, FailoverHttpClient httpClient) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.userAgent = userAgent;
        this.httpClient = httpClient;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public Optional<RegistryAuthenticator> handleResponse(Response response) {
        return Optional.empty();
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "retrieve authentication method for " + this.registryEndpointRequestProperties.getServerUrl();
    }

    @Override
    public Optional<RegistryAuthenticator> handleHttpResponseException(ResponseException responseException) throws ResponseException, RegistryErrorException {
        if (responseException.getStatusCode() != 401) {
            throw responseException;
        }
        String authenticationMethod = responseException.getHeaders().getAuthenticate();
        if (authenticationMethod == null) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), responseException).addReason("'WWW-Authenticate' header not found").build();
        }
        try {
            return RegistryAuthenticator.fromAuthenticationMethod(authenticationMethod, this.registryEndpointRequestProperties, this.userAgent, this.httpClient);
        }
        catch (RegistryAuthenticationFailedException ex) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), ex).addReason("Failed get authentication method from 'WWW-Authenticate' header").build();
        }
    }
}

