/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BuildExtension;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;

public interface InterceptorBindingRegistrar
extends BuildExtension {
    @Deprecated(forRemoval=true)
    default public Map<DotName, Set<String>> registerAdditionalBindings() {
        return Collections.emptyMap();
    }

    default public List<InterceptorBinding> getAdditionalBindings() {
        Map<DotName, Set<String>> map = this.registerAdditionalBindings();
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorBinding> bindings = new ArrayList<InterceptorBinding>();
        for (Map.Entry<DotName, Set<String>> e : map.entrySet()) {
            bindings.add(InterceptorBinding.of(e.getKey(), e.getValue()));
        }
        return bindings;
    }

    public static interface InterceptorBinding {
        public static InterceptorBinding of(Class<? extends Annotation> clazz) {
            return InterceptorBinding.of(DotName.createSimple((String)clazz.getName()));
        }

        public static InterceptorBinding of(DotName name) {
            return InterceptorBinding.of(name, (String member) -> false);
        }

        public static InterceptorBinding of(Class<? extends Annotation> clazz, Predicate<String> predicate) {
            return InterceptorBinding.of(DotName.createSimple((String)clazz.getName()), predicate);
        }

        public static InterceptorBinding of(final DotName name, final Predicate<String> predicate) {
            return new InterceptorBinding(){

                @Override
                public boolean isNonbinding(String memberName) {
                    return predicate.test(memberName);
                }

                @Override
                public DotName getName() {
                    return name;
                }
            };
        }

        public static InterceptorBinding of(DotName name, Set<String> nonbinding) {
            return InterceptorBinding.of(name, nonbinding::contains);
        }

        public static InterceptorBinding of(Class<? extends Annotation> clazz, Set<String> nonbinding) {
            return InterceptorBinding.of(clazz, nonbinding::contains);
        }

        public DotName getName();

        public boolean isNonbinding(String var1);
    }
}

