/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndex;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniTuple;

public final class BavetJoinBridgeUniNode<A>
extends BavetAbstractUniNode<A>
implements BavetJoinBridgeNode {
    private final BavetAbstractUniNode<A> parentNode;
    private final Function<A, Object[]> mapping;
    private Consumer<BavetJoinBridgeUniTuple<A>> childTupleRefresher;
    private final BavetIndex<BavetJoinBridgeUniTuple<A>> index;

    public BavetJoinBridgeUniNode(BavetConstraintSession session, int nodeOrder, BavetAbstractUniNode<A> parentNode, Function<A, Object[]> mapping, BavetIndex<BavetJoinBridgeUniTuple<A>> index) {
        super(session, nodeOrder);
        this.parentNode = parentNode;
        this.mapping = mapping;
        this.index = index;
    }

    @Override
    public BavetJoinBridgeUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetJoinBridgeUniTuple<A>(this, parentTuple);
    }

    public void refresh(BavetJoinBridgeUniTuple<A> tuple) {
        A a = tuple.getFactA();
        if (tuple.getState() != BavetTupleState.CREATING) {
            this.index.remove(tuple);
        }
        if (tuple.isActive()) {
            Object[] indexProperties = this.mapping.apply(a);
            this.index.put(indexProperties, tuple);
        }
        this.childTupleRefresher.accept(tuple);
        tuple.refreshed();
    }

    public String toString() {
        return "JoinBridge()";
    }

    public BavetIndex<BavetJoinBridgeUniTuple<A>> getIndex() {
        return this.index;
    }

    public void setChildTupleRefresher(Consumer<BavetJoinBridgeUniTuple<A>> childTupleRefresher) {
        this.childTupleRefresher = childTupleRefresher;
    }
}

