/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.registry.RegistryAliasGroup;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ImageReference {
    private static final String DOCKER_HUB_REGISTRY = "registry-1.docker.io";
    private static final String DEFAULT_TAG = "latest";
    private static final String LIBRARY_REPOSITORY_PREFIX = "library/";
    private static final String REGISTRY_COMPONENT_REGEX = "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))";
    private static final String REGISTRY_REGEX = String.format("%s(?:\\.%s)*(?::\\d+)?", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))");
    private static final String REPOSITORY_COMPONENT_REGEX = "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*";
    private static final String REPOSITORY_REGEX = String.format("(?:%s/)*%s", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*");
    private static final String TAG_REGEX = "[\\w][\\w.-]{0,127}";
    private static final String REFERENCE_REGEX = String.format("^(?:(%s)/)?(%s)(?::(%s))?(?:@(%s))?$", REGISTRY_REGEX, REPOSITORY_REGEX, "[\\w][\\w.-]{0,127}", DescriptorDigest.DIGEST_REGEX);
    private static final Pattern REFERENCE_PATTERN = Pattern.compile(REFERENCE_REGEX);
    private final String registry;
    private final String repository;
    @Nullable
    private final String tag;
    @Nullable
    private final String digest;

    public static ImageReference parse(String reference) throws InvalidImageReferenceException {
        if (reference.equals("scratch")) {
            return ImageReference.scratch();
        }
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.find() || matcher.groupCount() < 4) {
            throw new InvalidImageReferenceException(reference);
        }
        String registry = matcher.group(1);
        String repository = matcher.group(2);
        String tag = matcher.group(3);
        String digest = matcher.group(4);
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)repository)) {
            throw new InvalidImageReferenceException(reference);
        }
        if (!(registry.contains(".") || registry.contains(":") || "localhost".equals(registry))) {
            repository = registry + "/" + repository;
            registry = DOCKER_HUB_REGISTRY;
        }
        if (DOCKER_HUB_REGISTRY.equals(registry) && repository.indexOf(47) < 0) {
            repository = LIBRARY_REPOSITORY_PREFIX + repository;
        }
        if (Strings.isNullOrEmpty((String)tag) && Strings.isNullOrEmpty((String)digest)) {
            tag = DEFAULT_TAG;
        }
        if (Strings.isNullOrEmpty((String)tag)) {
            tag = null;
        }
        if (Strings.isNullOrEmpty((String)digest)) {
            digest = null;
        }
        return new ImageReference(registry, repository, tag, digest);
    }

    public static ImageReference of(@Nullable String registry, String repository, @Nullable String qualifier) {
        if (!Strings.isNullOrEmpty((String)qualifier) && ImageReference.isValidDigest(qualifier)) {
            return ImageReference.of(registry, repository, null, qualifier);
        }
        return ImageReference.of(registry, repository, qualifier, null);
    }

    public static ImageReference of(@Nullable String registry, String repository, @Nullable String tag, @Nullable String digest) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)registry) || ImageReference.isValidRegistry(registry) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)ImageReference.isValidRepository(repository));
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)tag) || ImageReference.isValidTag(tag) ? 1 : 0) != 0);
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)digest) || ImageReference.isValidDigest(digest) ? 1 : 0) != 0);
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)tag) && Strings.isNullOrEmpty((String)digest)) {
            tag = DEFAULT_TAG;
        }
        return new ImageReference(registry, repository, tag, digest);
    }

    public static ImageReference scratch() {
        return new ImageReference("", "scratch", null, null);
    }

    public static boolean isValidRegistry(String registry) {
        return registry.matches(REGISTRY_REGEX);
    }

    public static boolean isValidRepository(String repository) {
        return repository.matches(REPOSITORY_REGEX);
    }

    public static boolean isValidTag(String tag) {
        return tag.matches(TAG_REGEX);
    }

    public static boolean isValidDigest(String digest) {
        return digest.matches(DescriptorDigest.DIGEST_REGEX);
    }

    public static boolean isDefaultTag(@Nullable String tag) {
        return DEFAULT_TAG.equals(tag);
    }

    private ImageReference(String registry, String repository, @Nullable String tag, @Nullable String digest) {
        Preconditions.checkArgument(("scratch".equals(repository) || !Strings.isNullOrEmpty((String)tag) || !Strings.isNullOrEmpty((String)digest) ? 1 : 0) != 0, (Object)"Either tag or digest needs to be set.");
        this.registry = RegistryAliasGroup.getHost(registry);
        this.repository = repository;
        this.tag = tag;
        this.digest = digest;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public Optional<String> getDigest() {
        return Optional.ofNullable(this.digest);
    }

    public String getQualifier() {
        if (!Strings.isNullOrEmpty((String)this.digest)) {
            return this.digest;
        }
        return (String)Preconditions.checkNotNull((Object)this.tag);
    }

    public boolean usesDefaultTag() {
        return ImageReference.isDefaultTag(this.tag);
    }

    public boolean isScratch() {
        return "".equals(this.registry) && "scratch".equals(this.repository) && Strings.isNullOrEmpty((String)this.tag) && Strings.isNullOrEmpty((String)this.digest);
    }

    public ImageReference withQualifier(String newQualifier) {
        if (ImageReference.isValidDigest(newQualifier)) {
            return ImageReference.of(this.registry, this.repository, this.tag, newQualifier);
        }
        return ImageReference.of(this.registry, this.repository, newQualifier, this.digest);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toStringWithQualifier() {
        return this.toString(true);
    }

    private String toString(boolean singleQualifier) {
        if (this.isScratch()) {
            return "scratch";
        }
        StringBuilder referenceString = new StringBuilder();
        if (!DOCKER_HUB_REGISTRY.equals(this.registry)) {
            referenceString.append(this.registry).append('/').append(this.repository);
        } else if (this.repository.startsWith(LIBRARY_REPOSITORY_PREFIX)) {
            referenceString.append(this.repository.substring(LIBRARY_REPOSITORY_PREFIX.length()));
        } else {
            referenceString.append(this.repository);
        }
        if (singleQualifier) {
            if (!Strings.isNullOrEmpty((String)this.digest)) {
                referenceString.append('@').append(this.digest);
            } else {
                referenceString.append(':').append(this.tag);
            }
        } else {
            if (!Strings.isNullOrEmpty((String)this.tag) && !this.usesDefaultTag()) {
                referenceString.append(':').append(this.tag);
            }
            if (!Strings.isNullOrEmpty((String)this.digest)) {
                referenceString.append('@').append(this.digest);
            }
        }
        return referenceString.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImageReference)) {
            return false;
        }
        ImageReference otherImageReference = (ImageReference)other;
        return this.registry.equals(otherImageReference.registry) && this.repository.equals(otherImageReference.repository) && Objects.equals(this.tag, otherImageReference.tag) && Objects.equals(this.digest, otherImageReference.digest);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.repository, this.tag, this.digest);
    }
}

