/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment.devconsole;

import io.quarkus.bootstrap.app.ArtifactResult;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.console.TempSystemProperties;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class RebuildHandler
extends DevConsolePostHandler {
    private final Map<String, String> config;

    public RebuildHandler(Map<String, String> config) {
        this.config = config;
    }

    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        QuarkusBootstrap existing = (QuarkusBootstrap)DevConsoleManager.getQuarkusBootstrap();
        try (TempSystemProperties properties = new TempSystemProperties();){
            for (Map.Entry<String, String> i : this.config.entrySet()) {
                properties.set(i.getKey(), i.getValue());
            }
            for (Map.Entry<String, String> i : form.entries()) {
                if (i.getValue().isEmpty()) continue;
                properties.set(i.getKey(), i.getValue());
            }
            QuarkusBootstrap quarkusBootstrap = existing.clonedBuilder().setMode(QuarkusBootstrap.Mode.PROD).setIsolateDeployment(true).build();
            try (CuratedApplication bootstrap = quarkusBootstrap.bootstrap();){
                AugmentResult augmentResult = bootstrap.createAugmentor().createProductionApplication();
                List containerArtifactResults = augmentResult.resultsMatchingType(s -> s.contains("container"));
                if (containerArtifactResults.size() >= 1) {
                    this.flashMessage(event, "Container-image: " + ((ArtifactResult)containerArtifactResults.get(0)).getMetadata().get("container-image") + " created.", Duration.ofSeconds(10L));
                }
            }
        }
    }
}

