/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class InsertSectionHelper
implements SectionHelper {
    private final String name;
    private final SectionBlock defaultBlock;

    public InsertSectionHelper(String name, SectionBlock defaultBlock) {
        this.name = name;
        this.defaultBlock = defaultBlock;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        SectionBlock extending = context.resolutionContext().getExtendingBlock(this.name);
        if (extending != null) {
            return context.execute(extending, context.resolutionContext());
        }
        return context.execute(this.defaultBlock, context.resolutionContext());
    }

    public static class Factory
    implements SectionHelperFactory<InsertSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("insert");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter("name", "$default$").build();
        }

        @Override
        public InsertSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new InsertSectionHelper(context.getParameter("name"), context.getBlocks().get(0));
        }
    }
}

