/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.processmigration.model.Plan;
import org.kie.processmigration.model.exceptions.PlanNotFoundException;
import org.kie.processmigration.service.PlanService;

@Path(value="/plans")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class PlanResource {
    @Inject
    PlanService planService;

    @GET
    public Response findAll() {
        return Response.ok(this.planService.findAll()).build();
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") Long id) throws PlanNotFoundException {
        return Response.ok((Object)((Object)this.planService.get(id))).build();
    }

    @POST
    public Response create(Plan plan) {
        if (plan.getId() != null) {
            throw new IllegalArgumentException("The plan ID must not be provided when creating a new plan");
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.planService.create(plan)).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response save(@PathParam(value="id") Long id, Plan plan) throws PlanNotFoundException {
        return Response.ok((Object)((Object)this.planService.update(id, plan))).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws PlanNotFoundException {
        return Response.ok((Object)((Object)this.planService.delete(id))).build();
    }
}

