/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.cors;

import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CORSFilter
implements Handler<RoutingContext> {
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");
    final CORSConfig corsConfig;
    final List<Pattern> allowedOriginsRegex;

    public CORSFilter(CORSConfig corsConfig) {
        this.corsConfig = corsConfig;
        this.allowedOriginsRegex = CORSFilter.parseAllowedOriginsRegex(this.corsConfig.origins);
    }

    public static boolean isConfiguredWithWildcard(Optional<List<String>> optionalList) {
        if (optionalList == null || !optionalList.isPresent()) {
            return true;
        }
        List<String> list = optionalList.get();
        return list.isEmpty() || list.size() == 1 && "*".equals(list.get(0));
    }

    public static List<Pattern> parseAllowedOriginsRegex(Optional<List<String>> allowedOrigins) {
        if (allowedOrigins == null || !allowedOrigins.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> allowOriginsRegex = new ArrayList<Pattern>();
        for (String o : allowedOrigins.get()) {
            if (o == null || !o.startsWith("/") || !o.endsWith("/")) continue;
            allowOriginsRegex.add(Pattern.compile(o.substring(1, o.length() - 1)));
        }
        return allowOriginsRegex;
    }

    public static boolean isOriginAllowedByRegex(List<Pattern> allowOriginsRegex, String origin) {
        if (allowOriginsRegex == null) {
            return false;
        }
        for (Pattern pattern : allowOriginsRegex) {
            if (!pattern.matcher(origin).matches()) continue;
            return true;
        }
        return false;
    }

    private void processRequestedHeaders(HttpServerResponse response, String allowHeadersValue) {
        if (CORSFilter.isConfiguredWithWildcard(this.corsConfig.headers)) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)allowHeadersValue);
        } else {
            ArrayList<String> requestedHeaders = new ArrayList<String>();
            for (String requestedHeader : COMMA_SEPARATED_SPLIT_REGEX.split(allowHeadersValue)) {
                requestedHeaders.add(requestedHeader.toLowerCase());
            }
            ArrayList<String> validRequestedHeaders = new ArrayList<String>();
            for (String configHeader : this.corsConfig.headers.get()) {
                if (!requestedHeaders.contains(configHeader.toLowerCase())) continue;
                validRequestedHeaders.add(configHeader);
            }
            if (!validRequestedHeaders.isEmpty()) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)String.join((CharSequence)",", validRequestedHeaders));
            }
        }
    }

    private void processMethods(HttpServerResponse response, String allowMethodsValue) {
        if (CORSFilter.isConfiguredWithWildcard(this.corsConfig.methods)) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)allowMethodsValue);
        } else {
            ArrayList<String> requestedMethods = new ArrayList<String>();
            for (String requestedMethod : COMMA_SEPARATED_SPLIT_REGEX.split(allowMethodsValue)) {
                requestedMethods.add(requestedMethod.toLowerCase());
            }
            ArrayList<String> validRequestedMethods = new ArrayList<String>();
            List methods = this.corsConfig.methods.get().stream().map(HttpMethod::valueOf).collect(Collectors.toList());
            for (HttpMethod configMethod : methods) {
                if (!requestedMethods.contains(configMethod.name().toLowerCase())) continue;
                validRequestedMethods.add(configMethod.name());
            }
            if (!validRequestedMethods.isEmpty()) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)String.join((CharSequence)",", validRequestedMethods));
            }
        }
    }

    public void handle(RoutingContext event) {
        Objects.requireNonNull(this.corsConfig, "CORS config is not set");
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            event.next();
        } else {
            boolean allowsOrigin;
            String requestedHeaders;
            String requestedMethods = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (requestedMethods != null) {
                this.processMethods(response, requestedMethods);
            }
            if ((requestedHeaders = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                this.processRequestedHeaders(response, requestedHeaders);
            }
            boolean bl = allowsOrigin = CORSFilter.isConfiguredWithWildcard(this.corsConfig.origins) || this.corsConfig.origins.get().contains(origin) || CORSFilter.isOriginAllowedByRegex(this.allowedOriginsRegex, origin);
            if (allowsOrigin) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
            }
            boolean allowCredentials = this.corsConfig.accessControlAllowCredentials.orElseGet(() -> this.corsConfig.origins.isPresent() && this.corsConfig.origins.get().contains(origin) && !origin.equals("*"));
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)String.valueOf(allowCredentials));
            Optional<List<String>> exposedHeaders = this.corsConfig.exposedHeaders;
            if (!CORSFilter.isConfiguredWithWildcard(exposedHeaders)) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)String.join((CharSequence)",", exposedHeaders.orElse(Collections.emptyList())));
            }
            if (request.method().equals((Object)HttpMethod.OPTIONS)) {
                if ((requestedHeaders != null || requestedMethods != null) && this.corsConfig.accessControlMaxAge.isPresent()) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(this.corsConfig.accessControlMaxAge.get().getSeconds()));
                }
                response.end();
            } else {
                event.next();
            }
        }
    }
}

