/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.ContainerDNSConfig;
import com.github.dockerjava.api.model.ContainerSpecConfig;
import com.github.dockerjava.api.model.ContainerSpecPrivileges;
import com.github.dockerjava.api.model.ContainerSpecSecret;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.Mount;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

public class ContainerSpec
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Command")
    private List<String> command;
    @JsonProperty(value="Args")
    private List<String> args;
    @JsonProperty(value="Env")
    private List<String> env;
    @JsonProperty(value="Dir")
    private String dir;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Groups")
    private String groups;
    @JsonProperty(value="TTY")
    private Boolean tty;
    @JsonProperty(value="Mounts")
    private List<Mount> mounts;
    @JsonProperty(value="Duration")
    private Long duration;
    @JsonProperty(value="StopGracePeriod")
    private Long stopGracePeriod;
    @JsonProperty(value="DNSConfig")
    private ContainerDNSConfig dnsConfig;
    @JsonProperty(value="OpenStdin")
    private Boolean openStdin;
    @JsonProperty(value="ReadOnly")
    private Boolean readOnly;
    @JsonProperty(value="Hosts")
    private List<String> hosts;
    @JsonProperty(value="Hostname")
    private String hostname;
    @JsonProperty(value="Secrets")
    private List<ContainerSpecSecret> secrets;
    @JsonProperty(value="Healthcheck")
    private HealthCheck healthCheck;
    @JsonProperty(value="StopSignal")
    private String stopSignal;
    @JsonProperty(value="Privileges")
    private ContainerSpecPrivileges privileges;
    @JsonProperty(value="Configs")
    private List<ContainerSpecConfig> configs;

    @CheckForNull
    public String getImage() {
        return this.image;
    }

    public ContainerSpec withImage(String image) {
        this.image = image;
        return this;
    }

    @CheckForNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public ContainerSpec withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @CheckForNull
    public List<String> getCommand() {
        return this.command;
    }

    public ContainerSpec withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    @CheckForNull
    public List<String> getArgs() {
        return this.args;
    }

    public ContainerSpec withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    @CheckForNull
    public List<String> getEnv() {
        return this.env;
    }

    public ContainerSpec withEnv(List<String> env) {
        this.env = env;
        return this;
    }

    @CheckForNull
    public String getDir() {
        return this.dir;
    }

    public ContainerSpec withDir(String dir) {
        this.dir = dir;
        return this;
    }

    @CheckForNull
    public String getUser() {
        return this.user;
    }

    public ContainerSpec withUser(String user) {
        this.user = user;
        return this;
    }

    @CheckForNull
    public String getGroups() {
        return this.groups;
    }

    public ContainerSpec withGroups(String groups) {
        this.groups = groups;
        return this;
    }

    @CheckForNull
    public Boolean getTty() {
        return this.tty;
    }

    public ContainerSpec withTty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    @CheckForNull
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public ContainerSpec withMounts(List<Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    @CheckForNull
    public Long getDuration() {
        return this.duration;
    }

    public ContainerSpec withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public ContainerDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public ContainerSpec withDnsConfig(ContainerDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public Boolean getOpenStdin() {
        return this.openStdin;
    }

    public ContainerSpec withOpenStdin(Boolean openStdin) {
        this.openStdin = openStdin;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public ContainerSpec withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public ContainerSpec withHosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ContainerSpec withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public List<ContainerSpecSecret> getSecrets() {
        return this.secrets;
    }

    public ContainerSpec withSecrets(List<ContainerSpecSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public ContainerSpec withHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
        return this;
    }

    public String getStopSignal() {
        return this.stopSignal;
    }

    public ContainerSpec withStopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    public Long getStopGracePeriod() {
        return this.stopGracePeriod;
    }

    public ContainerSpec withStopGracePeriod(Long stopGracePeriod) {
        this.stopGracePeriod = stopGracePeriod;
        return this;
    }

    public ContainerSpecPrivileges getPrivileges() {
        return this.privileges;
    }

    public ContainerSpec withPrivileges(ContainerSpecPrivileges privileges) {
        this.privileges = privileges;
        return this;
    }

    public List<ContainerSpecConfig> getConfigs() {
        return this.configs;
    }

    public ContainerSpec withConfigs(List<ContainerSpecConfig> configs) {
        this.configs = configs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerSpec)) {
            return false;
        }
        ContainerSpec other = (ContainerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$tty = this.getTty();
        Boolean other$tty = other.getTty();
        if (this$tty == null ? other$tty != null : !((Object)this$tty).equals(other$tty)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Long this$stopGracePeriod = this.getStopGracePeriod();
        Long other$stopGracePeriod = other.getStopGracePeriod();
        if (this$stopGracePeriod == null ? other$stopGracePeriod != null : !((Object)this$stopGracePeriod).equals(other$stopGracePeriod)) {
            return false;
        }
        Boolean this$openStdin = this.getOpenStdin();
        Boolean other$openStdin = other.getOpenStdin();
        if (this$openStdin == null ? other$openStdin != null : !((Object)this$openStdin).equals(other$openStdin)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<String> this$command = this.getCommand();
        List<String> other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        List<String> this$env = this.getEnv();
        List<String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$groups = this.getGroups();
        String other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) {
            return false;
        }
        List<Mount> this$mounts = this.getMounts();
        List<Mount> other$mounts = other.getMounts();
        if (this$mounts == null ? other$mounts != null : !((Object)this$mounts).equals(other$mounts)) {
            return false;
        }
        ContainerDNSConfig this$dnsConfig = this.getDnsConfig();
        ContainerDNSConfig other$dnsConfig = other.getDnsConfig();
        if (this$dnsConfig == null ? other$dnsConfig != null : !((Object)this$dnsConfig).equals(other$dnsConfig)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        List<ContainerSpecSecret> this$secrets = this.getSecrets();
        List<ContainerSpecSecret> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        HealthCheck this$healthCheck = this.getHealthCheck();
        HealthCheck other$healthCheck = other.getHealthCheck();
        if (this$healthCheck == null ? other$healthCheck != null : !((Object)this$healthCheck).equals(other$healthCheck)) {
            return false;
        }
        String this$stopSignal = this.getStopSignal();
        String other$stopSignal = other.getStopSignal();
        if (this$stopSignal == null ? other$stopSignal != null : !this$stopSignal.equals(other$stopSignal)) {
            return false;
        }
        ContainerSpecPrivileges this$privileges = this.getPrivileges();
        ContainerSpecPrivileges other$privileges = other.getPrivileges();
        if (this$privileges == null ? other$privileges != null : !((Object)this$privileges).equals(other$privileges)) {
            return false;
        }
        List<ContainerSpecConfig> this$configs = this.getConfigs();
        List<ContainerSpecConfig> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $tty = this.getTty();
        result = result * 59 + ($tty == null ? 43 : ((Object)$tty).hashCode());
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Long $stopGracePeriod = this.getStopGracePeriod();
        result = result * 59 + ($stopGracePeriod == null ? 43 : ((Object)$stopGracePeriod).hashCode());
        Boolean $openStdin = this.getOpenStdin();
        result = result * 59 + ($openStdin == null ? 43 : ((Object)$openStdin).hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<String> $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        List<String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : $groups.hashCode());
        List<Mount> $mounts = this.getMounts();
        result = result * 59 + ($mounts == null ? 43 : ((Object)$mounts).hashCode());
        ContainerDNSConfig $dnsConfig = this.getDnsConfig();
        result = result * 59 + ($dnsConfig == null ? 43 : ((Object)$dnsConfig).hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        List<ContainerSpecSecret> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        HealthCheck $healthCheck = this.getHealthCheck();
        result = result * 59 + ($healthCheck == null ? 43 : ((Object)$healthCheck).hashCode());
        String $stopSignal = this.getStopSignal();
        result = result * 59 + ($stopSignal == null ? 43 : $stopSignal.hashCode());
        ContainerSpecPrivileges $privileges = this.getPrivileges();
        result = result * 59 + ($privileges == null ? 43 : ((Object)$privileges).hashCode());
        List<ContainerSpecConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "ContainerSpec(image=" + this.getImage() + ", labels=" + this.getLabels() + ", command=" + this.getCommand() + ", args=" + this.getArgs() + ", env=" + this.getEnv() + ", dir=" + this.getDir() + ", user=" + this.getUser() + ", groups=" + this.getGroups() + ", tty=" + this.getTty() + ", mounts=" + this.getMounts() + ", duration=" + this.getDuration() + ", stopGracePeriod=" + this.getStopGracePeriod() + ", dnsConfig=" + this.getDnsConfig() + ", openStdin=" + this.getOpenStdin() + ", readOnly=" + this.getReadOnly() + ", hosts=" + this.getHosts() + ", hostname=" + this.getHostname() + ", secrets=" + this.getSecrets() + ", healthCheck=" + this.getHealthCheck() + ", stopSignal=" + this.getStopSignal() + ", privileges=" + this.getPrivileges() + ", configs=" + this.getConfigs() + ")";
    }
}

