/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v2;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.apache.v2.ApacheHttpResponse;
import com.google.api.client.http.apache.v2.ContentEntity;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;
    private RequestConfig.Builder requestConfig;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
        this.requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setNormalizeUri(false).setStaleConnectionCheckEnabled(false);
    }

    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        this.requestConfig.setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout);
    }

    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            Preconditions.checkState((boolean)(this.request instanceof HttpEntityEnclosingRequest), (String)"Apache HTTP client does not support %s requests with content.", (Object[])new Object[]{this.request.getRequestLine().getMethod()});
            ContentEntity entity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
            if (this.getContentLength() == -1L) {
                entity.setChunked(true);
            }
            ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        }
        this.request.setConfig(this.requestConfig.build());
        return new ApacheHttpResponse(this.request, this.httpClient.execute((HttpUriRequest)this.request));
    }
}

