/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlob;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.DatumWithConnection;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.LOB_DATUM})
public class BLOB
extends DatumWithConnection
implements oracle.jdbc.internal.OracleBlob,
OracleConcreteProxy {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_INVALID = -1;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    public static final int OLD_WRONG_DURATION_SESSION = 1;
    public static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    protected OracleBlob target = null;
    private oracle.jdbc.internal.OracleBlob ojiOracleBlob = null;

    protected BLOB() {
        OracleBlob oracleBlob = new OracleBlob();
        this.setTarget(null, oracleBlob, null, false);
    }

    public OracleBlob getTarget() {
        return this.target;
    }

    private void setTarget(oracle.jdbc.OracleConnection oracleConnection, OracleBlob oracleBlob, byte[] byArray, boolean bl) {
        Class<TxnReplayableBlob> clazz = TxnReplayableBlob.class;
        this.ojiOracleBlob = ConcreteProxyUtil.getProxyObject(oracleConnection, oracleBlob, clazz, this);
        this.target = oracleBlob;
        this.setShareBytes(this.target.shareBytes());
        this.targetDatumWithConnection = this.target;
        this.targetDatum = this.target;
        if (this.ojiOracleBlob != null) {
            try {
                Object object = ConcreteProxyUtil.checkAndGetACProxyConnection(oracleConnection);
                if (object != null && bl) {
                    ((TxnReplayableConnection)object).BLOBConstructorRecording(byArray, this);
                }
            }
            catch (SQLException sQLException) {
            }
            this.ojiOracleDatumWithConnection = this.ojiOracleBlob;
        } else {
            this.ojiOracleBlob = this.target;
        }
    }

    public void createAndSetShardingLobProxy(Class clazz, Object object) {
        this.ojiOracleBlob = ConcreteProxyUtil.getProxyObject(this.ojiOracleBlob, clazz, object);
        this.ojiOracleDatumWithConnection = this.ojiOracleBlob;
    }

    @Override
    public TxnReplayableBase getConcreteProxy() {
        if (this.ojiOracleBlob instanceof TxnReplayableBase) {
            return (TxnReplayableBase)((Object)this.ojiOracleBlob);
        }
        return null;
    }

    protected BLOB(OracleBlob oracleBlob) {
        this.setTarget(null, oracleBlob, null, false);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, boolean bl) throws SQLException {
        this(oracleConnection, byArray);
        this.target.setFromobject(bl);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        oracle.jdbc.OracleConnection oracleConnection2 = null;
        oracleConnection2 = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(oracleConnection);
        if (oracleConnection2 != null) {
            oracleConnection = oracleConnection2;
        }
        OracleBlob oracleBlob = new OracleBlob(oracleConnection, byArray);
        this.setTarget(oracleConnection, oracleBlob, byArray, oracleConnection2 != null);
    }

    @Override
    public long length() throws SQLException {
        return this.ojiOracleBlob.length();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        return this.ojiOracleBlob.lengthInternal();
    }

    @Override
    public final Flow.Publisher<byte[]> publisherOracle(long l2) throws SQLException {
        return this.ojiOracleBlob.publisherOracle(l2);
    }

    @Override
    public final Flow.Subscriber<byte[]> subscriberOracle(long l2) throws SQLException {
        return this.ojiOracleBlob.subscriberOracle(l2);
    }

    @Override
    public final Flow.Subscriber<byte[]> subscriberOracle(long l2, Flow.Subscriber<Long> subscriber) throws SQLException {
        return this.ojiOracleBlob.subscriberOracle(l2, subscriber);
    }

    @Override
    public final CompletionStage<Long> lengthInternalAsync() {
        return this.ojiOracleBlob.lengthInternalAsync();
    }

    @Override
    public final Flow.Publisher<Void> freeAsyncOracle() throws SQLException {
        return this.ojiOracleBlob.freeAsyncOracle();
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        return this.ojiOracleBlob.getBytes(l2, n2);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.ojiOracleBlob.getBinaryStream();
    }

    public InputStream getBinaryStream(boolean bl) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.getBinaryStream(bl);
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        return this.ojiOracleBlob.position(byArray, l2);
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        return this.ojiOracleBlob.position(blob, l2);
    }

    @Override
    public int getBytes(long l2, int n2, byte[] byArray) throws SQLException {
        return this.ojiOracleBlob.getBytes(l2, n2, byArray);
    }

    @Override
    public int putBytes(long l2, byte[] byArray) throws SQLException {
        return this.ojiOracleBlob.putBytes(l2, byArray);
    }

    @Override
    public int putBytes(long l2, byte[] byArray, int n2) throws SQLException {
        return this.ojiOracleBlob.putBytes(l2, byArray, n2);
    }

    @Override
    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.ojiOracleBlob.getBinaryOutputStream();
    }

    @Override
    public byte[] getLocator() {
        return this.ojiOracleBlob.getLocator();
    }

    @Override
    public void setLocator(byte[] byArray) {
        this.ojiOracleBlob.setLocator(byArray);
    }

    @Override
    public int getChunkSize() throws SQLException {
        return this.ojiOracleBlob.getChunkSize();
    }

    @Override
    public int getBufferSize() throws SQLException {
        return this.ojiOracleBlob.getBufferSize();
    }

    public static BLOB empty_lob() throws SQLException {
        return BLOB.getEmptyBLOB();
    }

    public static BLOB getEmptyBLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        OracleBlob oracleBlob = bLOB.getTarget();
        oracleBlob.setShareBytes(byArray);
        return bLOB;
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        return this.ojiOracleBlob.isEmptyLob();
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        return this.ojiOracleBlob.isSecureFile();
    }

    @Override
    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        return this.ojiOracleBlob.getBinaryOutputStream(l2);
    }

    @Override
    public InputStream getBinaryStream(long l2) throws SQLException {
        return this.ojiOracleBlob.getBinaryStream(l2);
    }

    @Override
    public void trim(long l2) throws SQLException {
        this.ojiOracleBlob.trim(l2);
    }

    public static BLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            throw (SQLException)DatabaseError.createSqlException(68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or to DURATION_CALL").fillInStackTrace();
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return BLOB.getDBAccess(oracleConnection).createTemporaryBlob(oracleConnection, bl, n3);
    }

    public static void freeTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return;
        }
        bLOB.freeTemporary();
    }

    public static boolean isTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return false;
        }
        return bLOB.isTemporary();
    }

    public static short getDuration(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return -1;
        }
        return bLOB.getDuration();
    }

    @Override
    public void freeTemporary() throws SQLException {
        this.ojiOracleBlob.freeTemporary();
    }

    @Override
    public boolean isTemporary() throws SQLException {
        return this.ojiOracleBlob.isTemporary();
    }

    @Override
    public short getDuration() throws SQLException {
        return this.ojiOracleBlob.getDuration();
    }

    @Override
    public void open(LargeObjectAccessMode largeObjectAccessMode) throws SQLException {
        this.ojiOracleBlob.open(largeObjectAccessMode);
    }

    public void open(int n2) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        this.target.open(n2);
    }

    @Override
    public void close() throws SQLException {
        this.ojiOracleBlob.close();
    }

    @Override
    public boolean isOpen() throws SQLException {
        return this.ojiOracleBlob.isOpen();
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.ojiOracleBlob.setBytes(l2, byArray);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        return this.ojiOracleBlob.setBytes(l2, byArray, n2, n3);
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        return this.ojiOracleBlob.setBinaryStream(l2);
    }

    @Override
    public void truncate(long l2) throws SQLException {
        this.ojiOracleBlob.truncate(l2);
    }

    @Override
    public Object toJdbc() throws SQLException {
        this.ojiOracleBlob.toJdbc();
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        return this.ojiOracleBlob.isConvertibleTo(clazz);
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.ojiOracleBlob.characterStreamValue();
    }

    public Reader characterStreamValue(boolean bl) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.characterStreamValue(bl);
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.ojiOracleBlob.asciiStreamValue();
    }

    public InputStream asciiStreamValue(boolean bl) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.asciiStreamValue(bl);
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.ojiOracleBlob.binaryStreamValue();
    }

    @Override
    public InputStream binaryStreamValue(boolean bl) throws SQLException {
        return this.ojiOracleBlob.binaryStreamValue(bl);
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return this.ojiOracleBlob.makeJdbcArray(n2);
    }

    @Override
    public BlobDBAccess getDBAccess() throws SQLException {
        return this.ojiOracleBlob.getDBAccess();
    }

    public static BlobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createBlobDBAccess();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return this.ojiOracleBlob.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long l2) {
        this.ojiOracleBlob.setLength(l2);
    }

    @Override
    public final void setChunkSize(int n2) {
        this.ojiOracleBlob.setChunkSize(n2);
    }

    @Override
    public final void setPrefetchedData(byte[] byArray) {
        this.ojiOracleBlob.setPrefetchedData(byArray);
    }

    @Override
    public final void setPrefetchedData(byte[] byArray, int n2) {
        this.ojiOracleBlob.setPrefetchedData(byArray, n2);
    }

    @Override
    public final byte[] getPrefetchedData() {
        return this.ojiOracleBlob.getPrefetchedData();
    }

    @Override
    public final int getPrefetchedDataSize() {
        return this.ojiOracleBlob.getPrefetchedDataSize();
    }

    @Override
    public final void setActivePrefetch(boolean bl) {
        this.ojiOracleBlob.setActivePrefetch(bl);
    }

    @Override
    public final void clearCachedData() {
        this.ojiOracleBlob.clearCachedData();
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.ojiOracleBlob.isActivePrefetch();
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        return this.ojiOracleBlob.canReadBasicLobDataInLocator();
    }

    @Override
    public void free() throws SQLException {
        this.ojiOracleBlob.free();
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        return this.ojiOracleBlob.getBinaryStream(l2, l3);
    }

    @Override
    public void setBytes(byte[] byArray) {
        this.ojiOracleBlob.setBytes(byArray);
    }

    @Override
    public void setACProxy(Object object) {
        this.ojiOracleBlob.setACProxy(object);
    }

    @Override
    public Object getACProxy() {
        return this.ojiOracleBlob.getACProxy();
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.toSQLXML(this.getPhysicalConnection().getDbCsId());
    }

    @Override
    public SQLXML toSQLXML(int n2) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return new XMLType((Connection)this.getPhysicalConnection(), this, n2);
    }
}

