/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.dmg.pmml.OutputField;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;

public class KiePMMLDroolsRule {
    private final String name;
    private final String statusToSet;
    private final List<OutputField> outputFields;
    private String agendaGroup;
    private String activationGroup;
    private String statusConstraint;
    private List<KiePMMLFieldOperatorValue> andConstraints;
    private List<KiePMMLFieldOperatorValue> orConstraints;
    private List<KiePMMLFieldOperatorValue> xorConstraints;
    private List<KiePMMLFieldOperatorValue> notConstraints;
    private Map<String, List<Object>> inConstraints;
    private Map<String, List<Object>> notInConstraints;
    private String ifBreakField;
    private String ifBreakOperator;
    private Object ifBreakValue;
    private String focusedAgendaGroup;
    private KiePMMLReasonCodeAndValue reasonCodeAndValue;
    private ResultCode resultCode;
    private Object result;
    private Double toAccumulate;
    private boolean accumulationResult = false;

    private KiePMMLDroolsRule(String name, String statusToSet, List<OutputField> outputFields) {
        this.name = name;
        this.statusToSet = statusToSet;
        this.outputFields = outputFields;
    }

    public static Builder builder(String name, String statusToSet, List<OutputField> outputFields) {
        return new Builder(name, statusToSet, outputFields);
    }

    public String getName() {
        return this.name;
    }

    public String getStatusToSet() {
        return this.statusToSet;
    }

    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public String getAgendaGroup() {
        return this.agendaGroup;
    }

    public String getActivationGroup() {
        return this.activationGroup;
    }

    public String getFocusedAgendaGroup() {
        return this.focusedAgendaGroup;
    }

    public String getStatusConstraint() {
        return this.statusConstraint;
    }

    public List<KiePMMLFieldOperatorValue> getAndConstraints() {
        return this.andConstraints != null ? Collections.unmodifiableList(this.andConstraints) : null;
    }

    public List<KiePMMLFieldOperatorValue> getOrConstraints() {
        return this.orConstraints != null ? Collections.unmodifiableList(this.orConstraints) : null;
    }

    public List<KiePMMLFieldOperatorValue> getXorConstraints() {
        return this.xorConstraints != null ? Collections.unmodifiableList(this.xorConstraints) : null;
    }

    public List<KiePMMLFieldOperatorValue> getNotConstraints() {
        return this.notConstraints != null ? Collections.unmodifiableList(this.notConstraints) : null;
    }

    public Map<String, List<Object>> getInConstraints() {
        return this.inConstraints != null ? Collections.unmodifiableMap(this.inConstraints) : null;
    }

    public Map<String, List<Object>> getNotInConstraints() {
        return this.notInConstraints != null ? Collections.unmodifiableMap(this.notInConstraints) : null;
    }

    public String getIfBreakField() {
        return this.ifBreakField;
    }

    public String getIfBreakOperator() {
        return this.ifBreakOperator;
    }

    public Object getIfBreakValue() {
        return this.ifBreakValue;
    }

    public KiePMMLReasonCodeAndValue getReasonCodeAndValue() {
        return this.reasonCodeAndValue;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public Object getResult() {
        return this.result;
    }

    public Double getToAccumulate() {
        return this.toAccumulate;
    }

    public boolean isAccumulationResult() {
        return this.accumulationResult;
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", KiePMMLDroolsRule.class.getSimpleName() + "[", "]");
        if (this.name != null) {
            stringJoiner.add("name='" + this.name + "'");
        }
        if (this.statusToSet != null) {
            stringJoiner.add("statusToSet='" + this.statusToSet + "'");
        }
        if (this.outputFields != null && !this.outputFields.isEmpty()) {
            stringJoiner.add("outputFields='" + this.outputFields + "'");
        }
        if (this.agendaGroup != null) {
            stringJoiner.add("agendaGroup='" + this.agendaGroup + "'");
        }
        if (this.activationGroup != null) {
            stringJoiner.add("activationGroup='" + this.activationGroup + "'");
        }
        if (this.statusConstraint != null) {
            stringJoiner.add("statusConstraint='" + this.statusConstraint + "'");
        }
        if (this.andConstraints != null && !this.andConstraints.isEmpty()) {
            stringJoiner.add("andConstraints='" + this.andConstraints + "'");
        }
        if (this.orConstraints != null && !this.orConstraints.isEmpty()) {
            stringJoiner.add("orConstraints='" + this.orConstraints + "'");
        }
        if (this.xorConstraints != null && !this.xorConstraints.isEmpty()) {
            stringJoiner.add("xorConstraints='" + this.xorConstraints + "'");
        }
        if (this.notConstraints != null && !this.notConstraints.isEmpty()) {
            stringJoiner.add("notConstraints='" + this.notConstraints + "'");
        }
        if (this.inConstraints != null && !this.inConstraints.isEmpty()) {
            stringJoiner.add("inConstraints='" + this.inConstraints + "'");
        }
        if (this.notInConstraints != null && !this.notInConstraints.isEmpty()) {
            stringJoiner.add("notInConstraints='" + this.notInConstraints + "'");
        }
        if (this.ifBreakField != null) {
            stringJoiner.add("ifBreakField='" + this.ifBreakField + "'");
        }
        if (this.ifBreakOperator != null) {
            stringJoiner.add("ifBreakOperator='" + this.ifBreakOperator + "'");
        }
        if (this.ifBreakValue != null) {
            stringJoiner.add("ifBreakValue='" + this.ifBreakValue + "'");
        }
        if (this.focusedAgendaGroup != null) {
            stringJoiner.add("focusedAgendaGroup='" + this.focusedAgendaGroup + "'");
        }
        if (this.resultCode != null) {
            stringJoiner.add("resultCode='" + this.resultCode + "'");
        }
        if (this.result != null) {
            stringJoiner.add("result='" + this.result + "'");
        }
        if (this.toAccumulate != null) {
            stringJoiner.add("toAccumulate='" + this.toAccumulate + "'");
        }
        stringJoiner.add("accumulationResult='" + this.accumulationResult + "'");
        return stringJoiner.toString();
    }

    public static class Builder {
        protected KiePMMLDroolsRule toBuild;

        public Builder(String name, String statusToSet, List<OutputField> outputFields) {
            this.toBuild = new KiePMMLDroolsRule(name, statusToSet, outputFields);
        }

        public Builder withStatusConstraint(String constraint) {
            this.toBuild.statusConstraint = constraint;
            return this;
        }

        public Builder withAndConstraints(List<KiePMMLFieldOperatorValue> constraints) {
            this.toBuild.andConstraints = constraints;
            return this;
        }

        public Builder withOrConstraints(List<KiePMMLFieldOperatorValue> constraints) {
            this.toBuild.orConstraints = constraints;
            return this;
        }

        public Builder withXorConstraints(List<KiePMMLFieldOperatorValue> constraints) {
            this.toBuild.xorConstraints = constraints;
            return this;
        }

        public Builder withNotConstraints(List<KiePMMLFieldOperatorValue> constraints) {
            this.toBuild.notConstraints = constraints;
            return this;
        }

        public Builder withInConstraints(Map<String, List<Object>> constraints) {
            this.toBuild.inConstraints = constraints;
            return this;
        }

        public Builder withNotInConstraints(Map<String, List<Object>> constraints) {
            this.toBuild.notInConstraints = constraints;
            return this;
        }

        public Builder withIfBreak(String ifBreakField, String ifBreakOperator, Object ifBreakValue) {
            this.toBuild.ifBreakField = ifBreakField;
            this.toBuild.ifBreakOperator = ifBreakOperator;
            this.toBuild.ifBreakValue = ifBreakValue;
            return this;
        }

        public Builder withResultCode(ResultCode resultCode) {
            this.toBuild.resultCode = resultCode;
            return this;
        }

        public Builder withResult(Object result) {
            this.toBuild.result = result;
            return this;
        }

        public Builder withAgendaGroup(String agendaGroup) {
            this.toBuild.agendaGroup = agendaGroup;
            return this;
        }

        public Builder withActivationGroup(String activationGroup) {
            this.toBuild.activationGroup = activationGroup;
            return this;
        }

        public Builder withFocusedAgendaGroup(String focusedAgendaGroup) {
            this.toBuild.focusedAgendaGroup = focusedAgendaGroup;
            return this;
        }

        public Builder withAccumulation(Number toAccumulate) {
            this.toBuild.toAccumulate = toAccumulate != null ? toAccumulate.doubleValue() : 0.0;
            return this;
        }

        public Builder withAccumulationResult(boolean accumulationResult) {
            this.toBuild.accumulationResult = accumulationResult;
            return this;
        }

        public Builder withReasonCodeAndValue(KiePMMLReasonCodeAndValue reasonCodeAndValue) {
            this.toBuild.reasonCodeAndValue = reasonCodeAndValue;
            return this;
        }

        public KiePMMLDroolsRule build() {
            return this.toBuild;
        }
    }
}

