/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.AnnotationCreatorImpl;
import io.quarkus.gizmo.AnnotationUtils;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.SignatureElement;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

class FieldCreatorImpl
implements FieldCreator,
SignatureElement<FieldCreatorImpl> {
    private final FieldDescriptor fieldDescriptor;
    private final List<AnnotationCreatorImpl> annotations = new ArrayList<AnnotationCreatorImpl>();
    private String signature;
    private int modifiers;

    public FieldCreatorImpl(FieldDescriptor fieldDescriptor) {
        this.fieldDescriptor = fieldDescriptor;
        this.modifiers = 2;
    }

    @Override
    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public FieldCreator setModifiers(int modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public void write(ClassVisitor file) {
        FieldVisitor fieldVisitor = file.visitField(this.modifiers, this.fieldDescriptor.getName(), this.fieldDescriptor.getType(), this.signature, null);
        for (AnnotationCreatorImpl annotation : this.annotations) {
            AnnotationVisitor av = fieldVisitor.visitAnnotation(DescriptorUtils.extToInt(annotation.getAnnotationType()), annotation.getRetentionPolicy() == RetentionPolicy.RUNTIME);
            for (Map.Entry<String, Object> e : annotation.getValues().entrySet()) {
                AnnotationUtils.visitAnnotationValue(av, e.getKey(), e.getValue());
            }
            av.visitEnd();
        }
        fieldVisitor.visitEnd();
    }

    @Override
    public AnnotationCreator addAnnotation(String annotationType, RetentionPolicy retentionPolicy) {
        AnnotationCreatorImpl ac = new AnnotationCreatorImpl(annotationType, retentionPolicy);
        this.annotations.add(ac);
        return ac;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public FieldCreatorImpl setSignature(String signature) {
        this.signature = signature;
        return this;
    }
}

