/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenModelBuilder
implements ModelBuilder {
    private final ModelBuilder builder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
    private final BootstrapMavenContext ctx;

    public MavenModelBuilder(BootstrapMavenContext ctx) {
        this.ctx = ctx;
    }

    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        LocalWorkspace workspace = this.ctx.getWorkspace();
        if (workspace != null) {
            DefaultArtifact artifact;
            request.setWorkspaceModelResolver((WorkspaceModelResolver)workspace);
            Model requestModel = this.getModel(request);
            if (requestModel != null && workspace.findArtifact((Artifact)(artifact = new DefaultArtifact(ModelUtils.getGroupId(requestModel), requestModel.getArtifactId(), null, "pom", ModelUtils.getVersion(requestModel)))) != null) {
                ModelBuildingResult result = workspace.getProject(artifact.getGroupId(), artifact.getArtifactId()).getModelBuildingResult();
                if (result != null) {
                    return result;
                }
                try {
                    this.completeWorkspaceProjectBuildRequest(request);
                }
                catch (BootstrapMavenException e) {
                    throw new RuntimeException("Failed to build model for " + ModelUtils.getGroupId(requestModel) + ":" + requestModel.getArtifactId() + ":" + ModelUtils.getVersion(requestModel), (Throwable)((Object)e));
                }
            }
        }
        return this.builder.build(request);
    }

    private Model getModel(ModelBuildingRequest request) {
        Model requestModel = request.getRawModel();
        if (requestModel == null && request.getModelSource() != null) {
            try {
                requestModel = ModelUtils.readModel(request.getModelSource().getInputStream());
                request.setRawModel(requestModel);
                if (request.getPomFile() != null) {
                    requestModel.setPomFile(request.getPomFile());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return requestModel;
    }

    private void completeWorkspaceProjectBuildRequest(ModelBuildingRequest request) throws BootstrapMavenException {
        HashSet addedProfiles = new HashSet();
        List profiles = request.getProfiles();
        profiles.forEach(p -> addedProfiles.add(p.getId()));
        List<Profile> activeSettingsProfiles = this.ctx.getActiveSettingsProfiles();
        activeSettingsProfiles.forEach(p -> {
            if (!addedProfiles.contains(p.getId())) {
                profiles.add(p);
                request.getActiveProfileIds().add(p.getId());
            }
        });
        BootstrapMavenOptions cliOptions = this.ctx.getCliOptions();
        request.getActiveProfileIds().addAll(cliOptions.getActiveProfileIds());
        request.getInactiveProfileIds().addAll(cliOptions.getInactiveProfileIds());
        request.setUserProperties(System.getProperties());
    }

    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.builder.build(request, result);
    }

    public Result<? extends Model> buildRawModel(File pomFile, int validationLevel, boolean locationTracking) {
        return this.builder.buildRawModel(pomFile, validationLevel, locationTracking);
    }
}

