/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.adapters;

import java.util.function.Supplier;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.NodeTransformer;
import org.dmg.pmml.tree.SimplifyingNodeTransformer;

public class NodeAdapter
extends XmlAdapter<ComplexNode, Node> {
    public static final ThreadLocal<NodeTransformer> NODE_TRANSFORMER_PROVIDER = ThreadLocal.withInitial(new Supplier<NodeTransformer>(){

        @Override
        public NodeTransformer get() {
            return SimplifyingNodeTransformer.INSTANCE;
        }
    });

    public Node unmarshal(ComplexNode value) {
        NodeTransformer nodeTransformer = NODE_TRANSFORMER_PROVIDER.get();
        return nodeTransformer.fromComplexNode(value);
    }

    public ComplexNode marshal(Node node) {
        NodeTransformer nodeTransformer = NODE_TRANSFORMER_PROVIDER.get();
        return nodeTransformer.toComplexNode(node);
    }
}

