/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import javax.annotation.Nullable;

class RegistryErrorExceptionBuilder {
    @Nullable
    private final Throwable cause;
    private final StringBuilder errorMessageBuilder = new StringBuilder();
    private boolean firstErrorReason = true;

    private static String getReason(@Nullable String errorCodeString, @Nullable String message) {
        if (message == null) {
            message = "no details";
        }
        if (errorCodeString == null) {
            return "unknown: " + message;
        }
        try {
            switch (ErrorCodes.valueOf(errorCodeString)) {
                case MANIFEST_INVALID: 
                case BLOB_UNKNOWN: {
                    return message + " (something went wrong)";
                }
                case MANIFEST_UNKNOWN: 
                case TAG_INVALID: 
                case MANIFEST_UNVERIFIED: {
                    return message;
                }
            }
            return "other: " + message;
        }
        catch (IllegalArgumentException ex) {
            return "unknown error code: " + errorCodeString + " (" + message + ")";
        }
    }

    RegistryErrorExceptionBuilder(String method, @Nullable Throwable cause) {
        this.cause = cause;
        this.errorMessageBuilder.append("Tried to ");
        this.errorMessageBuilder.append(method);
        this.errorMessageBuilder.append(" but failed because: ");
    }

    RegistryErrorExceptionBuilder(String method) {
        this(method, null);
    }

    RegistryErrorExceptionBuilder addReason(ErrorEntryTemplate errorEntry) {
        String reason = RegistryErrorExceptionBuilder.getReason(errorEntry.getCode(), errorEntry.getMessage());
        this.addReason(reason);
        return this;
    }

    RegistryErrorExceptionBuilder addReason(String reason) {
        if (!this.firstErrorReason) {
            this.errorMessageBuilder.append(", ");
        }
        this.errorMessageBuilder.append(reason);
        this.firstErrorReason = false;
        return this;
    }

    RegistryErrorException build() {
        this.errorMessageBuilder.append(" | If this is a bug, please file an issue at https://github.com/GoogleContainerTools/jib/issues/new");
        return new RegistryErrorException(this.errorMessageBuilder.toString(), this.cause);
    }
}

