/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.oracle.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(OracleDevServicesProcessor.class);
    public static final String IMAGE = "gvenzl/oracle-xe";
    public static final String TAG = "21.3.0-slim";
    public static final String DEFAULT_DATABASE_USER = "quarkus";
    public static final String DEFAULT_DATABASE_PASSWORD = "quarkus";
    public static final String DEFAULT_DATABASE_NAME = "quarkusdb";
    public static final int PORT = 1521;

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupOracle(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("oracle", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> containerProperties, Map<String, String> additionalJdbcUrlProperties, OptionalInt fixedExposedPort, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                final QuarkusOracleServerContainer container = new QuarkusOracleServerContainer(imageName, fixedExposedPort, !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusOracleServerContainer)container).withStartupTimeout(arg_0));
                container.withUsername(username.orElse("quarkus")).withPassword(password.orElse("quarkus")).withDatabaseName(datasourceName.orElse(OracleDevServicesProcessor.DEFAULT_DATABASE_NAME));
                additionalJdbcUrlProperties.forEach((arg_0, arg_1) -> ((QuarkusOracleServerContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                LOG.info((Object)"Dev Services for Oracle started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getEffectiveJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                        LOG.info((Object)"Dev Services for Oracle shut down.");
                    }
                });
            }
        });
    }

    private static class QuarkusOracleServerContainer
    extends OracleContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusOracleServerContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElse("docker.io/gvenzl/oracle-xe:21.3.0-slim")).asCompatibleSubstituteFor(OracleDevServicesProcessor.IMAGE));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"oracle");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 1521);
            } else {
                this.addExposedPort(1521);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                return "jdbc:oracle:thin//" + this.hostName + ":1521:" + this.getDatabaseName();
            }
            return super.getJdbcUrl();
        }
    }
}

