/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.impl.solver.DefaultSolverJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverManager<Solution_, ProblemId_>
implements SolverManager<Solution_, ProblemId_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BiConsumer<ProblemId_, Throwable> defaultExceptionHandler = (problemId, throwable) -> this.logger.error("Solving failed for problemId ({}).", problemId, throwable);
    private final SolverFactory<Solution_> solverFactory;
    private final int parallelSolverCount;
    private final ExecutorService solverThreadPool;
    private ConcurrentMap<Object, DefaultSolverJob<Solution_, ProblemId_>> problemIdToSolverJobMap;

    public DefaultSolverManager(SolverFactory<Solution_> solverFactory, SolverManagerConfig solverManagerConfig) {
        this.solverFactory = solverFactory;
        this.validateSolverFactory();
        this.parallelSolverCount = solverManagerConfig.resolveParallelSolverCount();
        this.solverThreadPool = Executors.newFixedThreadPool(this.parallelSolverCount);
        this.problemIdToSolverJobMap = new ConcurrentHashMap<Object, DefaultSolverJob<Solution_, ProblemId_>>(this.parallelSolverCount * 10);
    }

    public SolverFactory<Solution_> getSolverFactory() {
        return this.solverFactory;
    }

    private void validateSolverFactory() {
        this.solverFactory.buildSolver();
    }

    protected ConcurrentMap<Object, DefaultSolverJob<Solution_, ProblemId_>> getProblemIdToSolverJobMap() {
        return this.problemIdToSolverJobMap;
    }

    @Override
    public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        return this.solve(problemId, problemFinder, null, finalBestSolutionConsumer, exceptionHandler);
    }

    @Override
    public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        return this.solve(problemId, problemFinder, bestSolutionConsumer, finalBestSolutionConsumer, exceptionHandler);
    }

    protected SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        Solver solver = this.solverFactory.buildSolver();
        if (bestSolutionConsumer != null) {
            solver.addEventListener(event -> bestSolutionConsumer.accept((Object)event.getNewBestSolution()));
        }
        BiConsumer<Object, Throwable> finalExceptionHandler = exceptionHandler != null ? exceptionHandler : this.defaultExceptionHandler;
        DefaultSolverJob solverJob = this.problemIdToSolverJobMap.compute(problemId, (key, oldSolverJob) -> {
            if (oldSolverJob != null) {
                throw new IllegalStateException("The problemId (" + problemId + ") is already solving.");
            }
            return new DefaultSolverJob(this, solver, problemId, problemFinder, finalBestSolutionConsumer, finalExceptionHandler);
        });
        Future future = this.solverThreadPool.submit(solverJob);
        solverJob.setFuture(future);
        return solverJob;
    }

    @Override
    public SolverStatus getSolverStatus(ProblemId_ problemId) {
        DefaultSolverJob solverJob = (DefaultSolverJob)this.problemIdToSolverJobMap.get(problemId);
        if (solverJob == null) {
            return SolverStatus.NOT_SOLVING;
        }
        return solverJob.getSolverStatus();
    }

    @Override
    public void terminateEarly(ProblemId_ problemId) {
        DefaultSolverJob solverJob = (DefaultSolverJob)this.problemIdToSolverJobMap.get(problemId);
        if (solverJob == null) {
            this.logger.debug("Ignoring terminateEarly() call because problemId ({}) is not solving.", problemId);
            return;
        }
        solverJob.terminateEarly();
    }

    @Override
    public void close() {
        this.solverThreadPool.shutdownNow();
    }
}

