/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class XdgDirectories {
    private static final Logger LOGGER = Logger.getLogger(XdgDirectories.class.getName());
    private static final Path JIB_SUBDIRECTORY_LINUX = Paths.get("google-cloud-tools-java", new String[0]).resolve("jib");
    private static final Path JIB_SUBDIRECTORY_OTHER = Paths.get("Google", new String[0]).resolve("Jib");

    public static Path getCacheHome() {
        return XdgDirectories.getCacheHome(System.getProperties(), System.getenv());
    }

    public static Path getConfigHome() {
        return XdgDirectories.getConfigHome(System.getProperties(), System.getenv());
    }

    @VisibleForTesting
    static Path getCacheHome(Properties properties, Map<String, String> environment) {
        return XdgDirectories.getOsSpecificDirectory(properties, environment, "XDG_CACHE_HOME", ".cache", "Cache", "Caches");
    }

    @VisibleForTesting
    static Path getConfigHome(Properties properties, Map<String, String> environment) {
        return XdgDirectories.getOsSpecificDirectory(properties, environment, "XDG_CONFIG_HOME", ".config", "Config", "Preferences");
    }

    private static Path getOsSpecificDirectory(Properties properties, Map<String, String> environment, String xdgEnvVariable, String linuxFolder, String windowsFolder, String macFolder) {
        Path windowsSubDirectory = JIB_SUBDIRECTORY_OTHER.resolve(windowsFolder);
        String rawOsName = properties.getProperty("os.name");
        String osName = rawOsName.toLowerCase(Locale.ENGLISH);
        String xdgHome = environment.get(xdgEnvVariable);
        String userHome = properties.getProperty("user.home");
        Path xdgPath = Paths.get(userHome, linuxFolder);
        if (osName.contains("linux")) {
            if (xdgHome != null && !xdgHome.trim().isEmpty()) {
                return Paths.get(xdgHome, new String[0]).resolve(JIB_SUBDIRECTORY_LINUX);
            }
            return xdgPath.resolve(JIB_SUBDIRECTORY_LINUX);
        }
        if (osName.contains("windows")) {
            if (xdgHome != null && !xdgHome.trim().isEmpty()) {
                return Paths.get(xdgHome, new String[0]).resolve(windowsSubDirectory);
            }
            String localAppDataEnv = environment.get("LOCALAPPDATA");
            if (localAppDataEnv == null || localAppDataEnv.trim().isEmpty()) {
                LOGGER.warning("LOCALAPPDATA environment is invalid or missing");
                return xdgPath.resolve(windowsSubDirectory);
            }
            Path localAppData = Paths.get(localAppDataEnv, new String[0]);
            if (!Files.exists(localAppData, new LinkOption[0])) {
                LOGGER.warning(() -> localAppData + " does not exist");
                return xdgPath.resolve(windowsSubDirectory);
            }
            return localAppData.resolve(windowsSubDirectory);
        }
        if (osName.contains("mac") || osName.contains("darwin")) {
            if (xdgHome != null && !xdgHome.trim().isEmpty()) {
                return Paths.get(xdgHome, new String[0]).resolve(JIB_SUBDIRECTORY_OTHER);
            }
            Path macDirectory = Paths.get(userHome, "Library", macFolder);
            if (!Files.exists(macDirectory, new LinkOption[0])) {
                LOGGER.warning(() -> macDirectory + " does not exist");
                return xdgPath.resolve(JIB_SUBDIRECTORY_OTHER);
            }
            return macDirectory.resolve(JIB_SUBDIRECTORY_OTHER);
        }
        throw new IllegalStateException("Unknown OS: " + rawOsName);
    }

    private XdgDirectories() {
    }
}

