/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.Arrays;
import java.util.Date;
import org.kie.pmml.api.enums.Named;
import org.kie.pmml.api.enums.builtinfunctions.ArithmeticFunctions;
import org.kie.pmml.api.enums.builtinfunctions.BooleanFunctions;
import org.kie.pmml.api.enums.builtinfunctions.DateFunctions;
import org.kie.pmml.api.enums.builtinfunctions.DistributionFunctions;
import org.kie.pmml.api.enums.builtinfunctions.MathematicalFunctions;
import org.kie.pmml.api.enums.builtinfunctions.StringFunctions;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;

public enum BUILTIN_FUNCTIONS implements Named
{
    PLUS("+"),
    MINUS("-"),
    MULTI("*"),
    DIVISION("/"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    AVG("avg"),
    MEDIAN("median"),
    PRODUCT("product"),
    LOG10("log10"),
    LN("ln"),
    SQRT("sqrt"),
    ABS("abs"),
    EXP("exp"),
    POW("pow"),
    THRESHOLD("threshold"),
    FLOOR("floor"),
    CEIL("ceil"),
    ROUND("round"),
    MODULO("modulo"),
    IS_MISSING("isMissing"),
    IS_NOT_MISSING("isNotMissing"),
    IS_VALID("isValid"),
    IS_NOT_VALID("isNotValid"),
    EQUAL("equal"),
    NOT_EQUAL("notEqual"),
    LESS_THAN("lessThan"),
    LESS_OR_EQUAL("lessOrEqual"),
    GREATER_THAN("greaterThan"),
    GREATER_OR_EQUAL("greaterOrEqual"),
    AND("and"),
    OR("or"),
    NOT("not"),
    IS_IN("isIn"),
    IS_NOT_IN("isNotIn"),
    IF("if"),
    UPPERCASE("uppercase"),
    LOWERCASE("lowercase"),
    STRING_LENGTH("stringLength"),
    SUBSTRING("substring"),
    TRIM_BLANKS("trimBlanks"),
    CONCAT("concat"),
    REPLACE("replace"),
    MATCHES("matches"),
    FORMAT_NUMBER("formatNumber"),
    FORMAT_DATE_TIME("formatDatetime"),
    DATE_DAYS_SINCE_YEAR("dateDaysSinceYear"),
    DATE_SECONDS_SINCE_YEAR("dateSecondsSinceYear"),
    DATE_SECONDS_SINCE_MIDNIGHT("dateSecondsSinceMidnight"),
    NORMAL_CDF("normalCDF"),
    NORMAL_PDF("normalPDF"),
    STD_NORMAL_CDF("stdNormalCDF"),
    STD_NORMAL_PDF("stdNormalPDF"),
    ERF("erf"),
    NORMAL_IDF("normalIDF"),
    STD_NORMAL_IDF("stdNormalIDF"),
    EXPM1("expm1"),
    HYPOT("hypot"),
    LN1P("ln1p"),
    RINT("rint"),
    SIN("sin"),
    ASIN("asin"),
    SINH("sinh"),
    COS("cos"),
    ACOS("acos"),
    COSH("cosh"),
    TAN("tan"),
    ATAN("atan"),
    TANH("tanh");

    private final String name;

    private BUILTIN_FUNCTIONS(String name) {
        this.name = name;
    }

    public static boolean isBUILTIN_FUNCTIONS(String name) {
        return Arrays.stream(BUILTIN_FUNCTIONS.values()).anyMatch(value -> name.equals(value.name));
    }

    public static boolean isBUILTIN_FUNCTIONS_VALIDATION(String name) {
        return BooleanFunctions.isBooleanFunctionsValidation(name);
    }

    public static BUILTIN_FUNCTIONS byName(String name) {
        return Arrays.stream(BUILTIN_FUNCTIONS.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find BUILTIN_FUNCTIONS with name: " + name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData, MiningField referredByFieldRef) {
        if (ArithmeticFunctions.isArithmeticFunctions(this.name)) {
            return ArithmeticFunctions.byName(this.name).getValue(inputData);
        }
        if (BooleanFunctions.isBooleanFunctions(this.name)) {
            return BooleanFunctions.byName(this.name).getValue(inputData, referredByFieldRef);
        }
        if (DateFunctions.isDateFunctions(this.name)) {
            return DateFunctions.byName(this.name).getValue(inputData);
        }
        if (DistributionFunctions.isDistributionFunctions(this.name)) {
            return DistributionFunctions.byName(this.name).getValue(inputData);
        }
        if (MathematicalFunctions.isMathematicalFunctions(this.name)) {
            return MathematicalFunctions.byName(this.name).getValue(inputData);
        }
        if (StringFunctions.isStringFunctions(this.name)) {
            return StringFunctions.byName(this.name).getValue(inputData);
        }
        throw new KiePMMLException("Unmanaged BUILTIN_FUNCTIONS " + this);
    }

    public static void checkNumbers(Object[] inputData, int expectedSize) {
        BUILTIN_FUNCTIONS.checkLength(inputData, expectedSize);
        for (Object object : inputData) {
            BUILTIN_FUNCTIONS.checkNumber(object);
        }
    }

    public static void checkNumber(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Expected only Numbers");
        }
    }

    public static void checkInteger(Object object) {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException("Expected only Integer");
        }
    }

    public static void checkStrings(Object[] inputData, int expectedSize) {
        BUILTIN_FUNCTIONS.checkLength(inputData, expectedSize);
        for (Object object : inputData) {
            BUILTIN_FUNCTIONS.checkString(object);
        }
    }

    public static void checkString(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Expected only String");
        }
    }

    public static void checkBooleans(Object[] inputData, int expectedSize) {
        BUILTIN_FUNCTIONS.checkLength(inputData, expectedSize);
        for (Object object : inputData) {
            BUILTIN_FUNCTIONS.checkBoolean(object);
        }
    }

    public static void checkBoolean(Object object) {
        if (!(object instanceof Boolean)) {
            throw new IllegalArgumentException("Expected only Booleans");
        }
    }

    public static void checkDates(Object[] inputData, int expectedSize) {
        BUILTIN_FUNCTIONS.checkLength(inputData, expectedSize);
        for (Object object : inputData) {
            BUILTIN_FUNCTIONS.checkDate(object);
        }
    }

    public static void checkDate(Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Expected only Dates");
        }
    }

    public static void checkLength(Object[] inputData, int expectedSize) {
        if (inputData.length < 1) {
            throw new IllegalArgumentException("Expected at least one parameter");
        }
        if (inputData.length != expectedSize) {
            throw new IllegalArgumentException(String.format("Expected %s parameters ", expectedSize));
        }
    }

    public static void checkMinimumLength(Object[] inputData, int minimumLength) {
        if (inputData.length < minimumLength) {
            throw new IllegalArgumentException(String.format("Expected at least %s parameters ", minimumLength));
        }
    }

    public static void checkRangeLength(Object[] inputData, int minimumLength, int maximumLength) {
        if (inputData.length < minimumLength) {
            throw new IllegalArgumentException(String.format("Expected at least %s parameters ", minimumLength));
        }
        if (inputData.length > maximumLength) {
            throw new IllegalArgumentException(String.format("Expected at most %s parameters ", maximumLength));
        }
    }
}

