/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.DeploymentInjectingDependencyVisitor;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactRequest;

public class BuildDependencyGraphVisitor {
    private final Set<ArtifactKey> allRuntimeDeps;
    private final StringBuilder buf;
    private final Consumer<String> buildTreeConsumer;
    private final List<Boolean> depth;
    private DependencyNode currentDeployment;
    private DependencyNode currentRuntime;
    private Artifact runtimeArtifactToFind;
    private final List<DependencyNode> deploymentDepNodes = new ArrayList<DependencyNode>();
    private final List<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();

    public BuildDependencyGraphVisitor(Set<ArtifactKey> allRuntimeDeps, Consumer<String> buildTreeConsumer) {
        this.allRuntimeDeps = allRuntimeDeps;
        this.buildTreeConsumer = buildTreeConsumer;
        if (buildTreeConsumer == null) {
            this.buf = null;
            this.depth = null;
        } else {
            this.buf = new StringBuilder();
            this.depth = new ArrayList<Boolean>();
        }
    }

    public List<DependencyNode> getDeploymentNodes() {
        return this.deploymentDepNodes;
    }

    public List<ArtifactRequest> getArtifactRequests() {
        return this.requests;
    }

    public void visit(DependencyNode node) {
        if (this.depth != null) {
            this.consume(node);
        }
        Dependency dep = node.getDependency();
        DependencyNode previousDeployment = this.currentDeployment;
        DependencyNode previousRuntime = this.currentRuntime;
        Artifact previousRuntimeArtifact = this.runtimeArtifactToFind;
        Artifact newRuntimeArtifact = DeploymentInjectingDependencyVisitor.getRuntimeArtifact(node);
        if (newRuntimeArtifact != null) {
            this.currentDeployment = node;
            this.runtimeArtifactToFind = newRuntimeArtifact;
            this.currentRuntime = null;
        } else if (this.runtimeArtifactToFind != null && this.currentRuntime == null && this.runtimeArtifactToFind.equals(dep.getArtifact())) {
            this.currentRuntime = node;
            this.runtimeArtifactToFind = null;
        }
        List children = node.getChildren();
        if (!children.isEmpty()) {
            int childrenTotal = children.size();
            if (childrenTotal == 1) {
                if (this.depth != null) {
                    this.depth.add(false);
                }
                this.visit((DependencyNode)children.get(0));
            } else {
                if (this.depth != null) {
                    this.depth.add(true);
                }
                int i = 0;
                while (i < childrenTotal) {
                    this.visit((DependencyNode)children.get(i++));
                    if (this.depth == null || i != childrenTotal - 1) continue;
                    this.depth.set(this.depth.size() - 1, false);
                }
            }
            if (this.depth != null) {
                this.depth.remove(this.depth.size() - 1);
            }
        }
        this.visitLeave(node);
        this.currentDeployment = previousDeployment;
        this.currentRuntime = previousRuntime;
        this.runtimeArtifactToFind = previousRuntimeArtifact;
    }

    private void consume(DependencyNode node) {
        this.buf.setLength(0);
        if (!this.depth.isEmpty()) {
            for (int i = 0; i < this.depth.size() - 1; ++i) {
                if (this.depth.get(i).booleanValue()) {
                    this.buf.append('\u2502').append("  ");
                    continue;
                }
                this.buf.append("   ");
            }
            if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                this.buf.append('\u251c').append('\u2500').append(' ');
            } else {
                this.buf.append('\u2514').append('\u2500').append(' ');
            }
        }
        this.buf.append(node.getArtifact());
        if (!this.depth.isEmpty()) {
            this.buf.append(" (").append(node.getDependency().getScope());
            if (node.getDependency().isOptional()) {
                this.buf.append(" optional");
            }
            this.buf.append(')');
        }
        this.buildTreeConsumer.accept(this.buf.toString());
    }

    private void visitLeave(DependencyNode node) {
        Dependency dep = node.getDependency();
        if (dep == null) {
            return;
        }
        Artifact artifact = dep.getArtifact();
        if (artifact.getFile() == null) {
            this.requests.add(new ArtifactRequest(node));
        }
        if (this.currentDeployment != null) {
            if (this.currentRuntime == null && !this.allRuntimeDeps.contains(new GACT(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()))) {
                this.deploymentDepNodes.add(node);
            } else if (this.currentRuntime == node) {
                this.currentRuntime = null;
                this.runtimeArtifactToFind = null;
            }
            if (this.currentDeployment == node) {
                this.currentDeployment = null;
            }
        }
    }
}

