/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.rest;

import io.quarkus.runtime.Startup;
import io.smallrye.health.api.HealthRegistry;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.kie.processmigration.model.KieServerConfig;
import org.kie.processmigration.rest.KieServerHealthCheck;
import org.kie.processmigration.service.KieService;

@ApplicationScoped
@Startup
public class KieServerHealth {
    @Inject
    KieService kieService;
    @Inject
    @Liveness
    HealthRegistry livenessHealthRegistry;
    @Inject
    @Readiness
    HealthRegistry readinessHealthRegistry;

    @PostConstruct
    public void init() {
        this.kieService.getConfigs().forEach(this::register);
    }

    private void register(KieServerConfig conf) {
        KieServerHealthCheck healthCheck = new KieServerHealthCheck(conf);
        this.livenessHealthRegistry.register(conf.getName(), (HealthCheck)healthCheck);
        this.readinessHealthRegistry.register(conf.getName(), (HealthCheck)healthCheck);
    }
}

