/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.kie.processmigration.model.Execution;
import org.kie.processmigration.model.Migration;
import org.kie.processmigration.model.MigrationDefinition;
import org.kie.processmigration.model.exceptions.InvalidMigrationException;
import org.kie.processmigration.model.exceptions.MigrationNotFoundException;
import org.kie.processmigration.model.exceptions.ReScheduleException;
import org.kie.processmigration.service.MigrationService;

@Path(value="/migrations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class MigrationResource {
    private static final String ANONYMOUS = "ANONYMOUS";
    @Context
    SecurityContext securityContext;
    @Inject
    MigrationService migrationService;

    @GET
    public Response findAll() {
        return Response.ok(this.migrationService.findAll()).build();
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") Long id) throws MigrationNotFoundException {
        return Response.ok((Object)((Object)this.migrationService.get(id))).build();
    }

    @GET
    @Path(value="/{id}/results")
    public Response getResults(@PathParam(value="id") Long id) throws MigrationNotFoundException {
        return Response.ok(this.migrationService.getResults(id)).build();
    }

    @GET
    @Path(value="/{id}/results/{logId}")
    public Response getResultLog(@PathParam(value="id") Long id, @PathParam(value="logId") Long logId) {
        return Response.ok((Object)((Object)this.migrationService.getReport(logId))).build();
    }

    @POST
    public Response submit(@Context HttpHeaders headers, MigrationDefinition definition) throws InvalidMigrationException {
        this.setRequester(definition);
        Migration result = this.migrationService.submit(definition);
        if (Execution.ExecutionType.ASYNC.equals((Object)definition.getExecution().getType())) {
            return Response.accepted((Object)((Object)result)).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@Context HttpHeaders headers, @PathParam(value="id") Long id, MigrationDefinition definition) throws MigrationNotFoundException, InvalidMigrationException, ReScheduleException {
        this.setRequester(definition);
        Migration migration = this.migrationService.update(id, definition);
        return Response.ok((Object)((Object)migration)).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws MigrationNotFoundException {
        return Response.ok((Object)((Object)this.migrationService.delete(id))).build();
    }

    private void setRequester(MigrationDefinition migration) {
        String requester = ANONYMOUS;
        if (this.securityContext.getUserPrincipal() != null) {
            requester = this.securityContext.getUserPrincipal().getName();
        }
        migration.setRequester(requester);
    }
}

