/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service.impl;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.transaction.Transactional;
import org.kie.processmigration.model.Plan;
import org.kie.processmigration.model.exceptions.PlanNotFoundException;
import org.kie.processmigration.service.PlanService;

@ApplicationScoped
public class PlanServiceImpl
implements PlanService {
    @Override
    @Transactional
    public List<Plan> findAll() {
        return Plan.listAll();
    }

    @Override
    @Transactional
    public Plan get(Long id) throws PlanNotFoundException {
        Optional plan = Plan.findByIdOptional((Object)id);
        return (Plan)((Object)plan.orElseThrow(() -> new PlanNotFoundException(id)));
    }

    @Override
    @Transactional
    public Plan delete(Long id) throws PlanNotFoundException {
        Plan plan = this.get(id);
        plan.delete();
        return plan;
    }

    @Override
    @Transactional
    public Plan create(Plan plan) {
        plan.persist();
        return plan;
    }

    @Override
    @Transactional
    public Plan update(Long id, Plan plan) throws PlanNotFoundException {
        Plan current = this.get(id);
        current.copy(plan).persist();
        return current;
    }
}

