/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.filevault.runtime.encrypt;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;

public class EncryptionUtil {
    private static final Logger LOGGER = Logger.getLogger((String)EncryptionUtil.class.getName());
    private static final String ENC_ALGORITHM = "AES/GCM/NoPadding";
    private static final int ENC_TAG_LENGTH = 128;

    public static String decrypt(String strToDecrypt, String encryptionKey) {
        try {
            SecretKeySpec secretKey = EncryptionUtil.transformEncryptionKey(encryptionKey);
            Cipher cipher = Cipher.getInstance(ENC_ALGORITHM);
            ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getUrlDecoder().decode(strToDecrypt.getBytes(StandardCharsets.UTF_8)));
            byte ivLength = byteBuffer.get();
            byte[] iv = new byte[ivLength];
            byteBuffer.get(iv);
            byte[] encrypted = new byte[byteBuffer.remaining()];
            byteBuffer.get(encrypted);
            cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
            return new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while decrypting: " + e.toString()));
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(String strToEncrypt, String encryptionKey) {
        try {
            String decodedEncryptionKey = new String(Base64.getUrlDecoder().decode(encryptionKey), StandardCharsets.UTF_8);
            SecretKeySpec secretKey = EncryptionUtil.transformEncryptionKey(decodedEncryptionKey);
            Cipher cipher = Cipher.getInstance(ENC_ALGORITHM);
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
            byte[] encrypted = cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8));
            ByteBuffer message = ByteBuffer.allocate(1 + iv.length + encrypted.length);
            message.put((byte)iv.length);
            message.put(iv);
            message.put(encrypted);
            return Base64.getUrlEncoder().withoutPadding().encodeToString(message.array());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while encrypting: " + e.toString()));
            throw new RuntimeException(e);
        }
    }

    public static SecretKeySpec transformEncryptionKey(String encryptionKey) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(encryptionKey.getBytes(StandardCharsets.UTF_8));
            return new SecretKeySpec(sha256.digest(), "AES");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while transforming the encryption key: " + e.toString()));
            throw new RuntimeException(e);
        }
    }
}

