/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2;

import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dmg.pmml.pmml_4_2.descr.ACTIVATIONFUNCTION;
import org.dmg.pmml.pmml_4_2.descr.Application;
import org.dmg.pmml.pmml_4_2.descr.DATATYPE;
import org.dmg.pmml.pmml_4_2.descr.DataDictionary;
import org.dmg.pmml.pmml_4_2.descr.DataField;
import org.dmg.pmml.pmml_4_2.descr.DerivedField;
import org.dmg.pmml.pmml_4_2.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_2.descr.Header;
import org.dmg.pmml.pmml_4_2.descr.LinearNorm;
import org.dmg.pmml.pmml_4_2.descr.MININGFUNCTION;
import org.dmg.pmml.pmml_4_2.descr.MiningField;
import org.dmg.pmml.pmml_4_2.descr.MiningSchema;
import org.dmg.pmml.pmml_4_2.descr.NNNORMALIZATIONMETHOD;
import org.dmg.pmml.pmml_4_2.descr.NeuralInput;
import org.dmg.pmml.pmml_4_2.descr.NeuralInputs;
import org.dmg.pmml.pmml_4_2.descr.NeuralLayer;
import org.dmg.pmml.pmml_4_2.descr.NeuralNetwork;
import org.dmg.pmml.pmml_4_2.descr.NeuralOutput;
import org.dmg.pmml.pmml_4_2.descr.NeuralOutputs;
import org.dmg.pmml.pmml_4_2.descr.Neuron;
import org.dmg.pmml.pmml_4_2.descr.NormContinuous;
import org.dmg.pmml.pmml_4_2.descr.OPTYPE;
import org.dmg.pmml.pmml_4_2.descr.OUTLIERTREATMENTMETHOD;
import org.dmg.pmml.pmml_4_2.descr.Output;
import org.dmg.pmml.pmml_4_2.descr.OutputField;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.dmg.pmml.pmml_4_2.descr.Synapse;
import org.dmg.pmml.pmml_4_2.descr.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLGeneratorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PMMLGeneratorUtils.class);

    private static Marshaller initContext(PMML pmml) throws JAXBException {
        JAXBContext pContext = JAXBContext.newInstance((String)pmml.getClass().getPackage().getName());
        Marshaller marshaller = pContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }

    public static boolean streamPMML(PMML pmml, OutputStream out) {
        try {
            Marshaller marshaller = PMMLGeneratorUtils.initContext(pmml);
            marshaller.marshal((Object)pmml, out);
            return true;
        }
        catch (JAXBException e) {
            LOG.error("Exception", (Throwable)e);
            return false;
        }
    }

    public static boolean streamPMML(PMML pmml, Writer out) {
        try {
            Marshaller marshaller = PMMLGeneratorUtils.initContext(pmml);
            marshaller.marshal((Object)pmml, out);
            return true;
        }
        catch (JAXBException e) {
            LOG.error("Exception", (Throwable)e);
            return false;
        }
    }

    public static PMML generateSimpleNeuralNetwork(String modelName, String[] inputfieldNames, String[] outputfieldNames, double[] inputMeans, double[] inputStds, double[] outputMeans, double[] outputStds, int hiddenSize, double[] weights) {
        MiningField mfld;
        DataField dataField;
        int counter = 0;
        int wtsIndex = 0;
        PMML pmml = new PMML();
        pmml.setVersion("4.0");
        Header header = new Header();
        Application app = new Application();
        app.setName("Drools PMML Generator");
        app.setVersion("0.01 Alpha");
        header.setApplication(app);
        header.setCopyright("BSD");
        header.setDescription(" Smart Vent Model ");
        Timestamp ts = new Timestamp();
        ts.getContent().add((Serializable)((Object)new Date().toString()));
        header.setTimestamp(ts);
        pmml.setHeader(header);
        DataDictionary dic = new DataDictionary();
        dic.setNumberOfFields(BigInteger.valueOf(inputfieldNames.length + outputfieldNames.length));
        for (String ifld : inputfieldNames) {
            dataField = new DataField();
            dataField.setName(ifld);
            dataField.setDataType(DATATYPE.DOUBLE);
            dataField.setDisplayName(ifld);
            dataField.setOptype(OPTYPE.CONTINUOUS);
            dic.getDataFields().add(dataField);
        }
        for (String ofld : outputfieldNames) {
            dataField = new DataField();
            dataField.setName(ofld);
            dataField.setDataType(DATATYPE.DOUBLE);
            dataField.setDisplayName(ofld);
            dataField.setOptype(OPTYPE.CONTINUOUS);
            dic.getDataFields().add(dataField);
        }
        pmml.setDataDictionary(dic);
        NeuralNetwork nnet = new NeuralNetwork();
        nnet.setActivationFunction(ACTIVATIONFUNCTION.LOGISTIC);
        nnet.setFunctionName(MININGFUNCTION.REGRESSION);
        nnet.setNormalizationMethod(NNNORMALIZATIONMETHOD.NONE);
        nnet.setModelName(modelName);
        MiningSchema miningSchema = new MiningSchema();
        for (String ifld : inputfieldNames) {
            mfld = new MiningField();
            mfld.setName(ifld);
            mfld.setOptype(OPTYPE.CONTINUOUS);
            mfld.setUsageType(FIELDUSAGETYPE.ACTIVE);
            miningSchema.getMiningFields().add(mfld);
        }
        for (String ofld : outputfieldNames) {
            mfld = new MiningField();
            mfld.setName(ofld);
            mfld.setOptype(OPTYPE.CONTINUOUS);
            mfld.setUsageType(FIELDUSAGETYPE.PREDICTED);
            miningSchema.getMiningFields().add(mfld);
        }
        nnet.getExtensionsAndNeuralLayersAndNeuralInputs().add(miningSchema);
        Output outputs = new Output();
        for (String ofld : outputfieldNames) {
            OutputField outFld = new OutputField();
            outFld.setName("Out_" + ofld);
            outFld.setTargetField(ofld);
            outputs.getOutputFields().add(outFld);
        }
        nnet.getExtensionsAndNeuralLayersAndNeuralInputs().add(outputs);
        NeuralInputs nins = new NeuralInputs();
        nins.setNumberOfInputs(BigInteger.valueOf(inputfieldNames.length));
        for (int j = 0; j < inputfieldNames.length; ++j) {
            String ifld = inputfieldNames[j];
            NeuralInput nin = new NeuralInput();
            nin.setId("" + counter++);
            DerivedField der = new DerivedField();
            der.setDataType(DATATYPE.DOUBLE);
            der.setOptype(OPTYPE.CONTINUOUS);
            NormContinuous nc = new NormContinuous();
            nc.setField(ifld);
            nc.setOutliers(OUTLIERTREATMENTMETHOD.AS_IS);
            LinearNorm lin1 = new LinearNorm();
            lin1.setOrig(0.0);
            lin1.setNorm(-inputMeans[j] / inputStds[j]);
            nc.getLinearNorms().add(lin1);
            LinearNorm lin2 = new LinearNorm();
            lin2.setOrig(inputMeans[j]);
            lin2.setNorm(0.0);
            nc.getLinearNorms().add(lin2);
            der.setNormContinuous(nc);
            nin.setDerivedField(der);
            nins.getNeuralInputs().add(nin);
        }
        nnet.getExtensionsAndNeuralLayersAndNeuralInputs().add(nins);
        NeuralLayer hidden = new NeuralLayer();
        hidden.setNumberOfNeurons(BigInteger.valueOf(hiddenSize));
        for (int j = 0; j < hiddenSize; ++j) {
            Neuron n = new Neuron();
            n.setId("" + counter++);
            n.setBias(weights[wtsIndex++]);
            for (int k = 0; k < inputfieldNames.length; ++k) {
                Synapse con = new Synapse();
                con.setFrom("" + k);
                con.setWeight(weights[wtsIndex++]);
                n.getCons().add(con);
            }
            hidden.getNeurons().add(n);
        }
        nnet.getExtensionsAndNeuralLayersAndNeuralInputs().add(hidden);
        NeuralLayer outer = new NeuralLayer();
        outer.setActivationFunction(ACTIVATIONFUNCTION.IDENTITY);
        outer.setNumberOfNeurons(BigInteger.valueOf(outputfieldNames.length));
        for (int j = 0; j < outputfieldNames.length; ++j) {
            Neuron n = new Neuron();
            n.setId("" + counter++);
            n.setBias(weights[wtsIndex++]);
            for (int k = 0; k < hiddenSize; ++k) {
                Synapse con = new Synapse();
                con.setFrom("" + (k + inputfieldNames.length));
                con.setWeight(weights[wtsIndex++]);
                n.getCons().add(con);
            }
            outer.getNeurons().add(n);
        }
        nnet.getExtensionsAndNeuralLayersAndNeuralInputs().add(outer);
        NeuralOutputs finalOuts = new NeuralOutputs();
        finalOuts.setNumberOfOutputs(BigInteger.valueOf(outputfieldNames.length));
        for (int j = 0; j < outputfieldNames.length; ++j) {
            NeuralOutput output = new NeuralOutput();
            output.setOutputNeuron("" + (j + inputfieldNames.length + hiddenSize));
            DerivedField der = new DerivedField();
            der.setDataType(DATATYPE.DOUBLE);
            der.setOptype(OPTYPE.CONTINUOUS);
            NormContinuous nc = new NormContinuous();
            nc.setField(outputfieldNames[j]);
            nc.setOutliers(OUTLIERTREATMENTMETHOD.AS_IS);
            LinearNorm lin1 = new LinearNorm();
            lin1.setOrig(0.0);
            lin1.setNorm(-outputMeans[j] / outputStds[j]);
            nc.getLinearNorms().add(lin1);
            LinearNorm lin2 = new LinearNorm();
            lin2.setOrig(outputMeans[j]);
            lin2.setNorm(0.0);
            nc.getLinearNorms().add(lin2);
            der.setNormContinuous(nc);
            output.setDerivedField(der);
            finalOuts.getNeuralOutputs().add(output);
        }
        nnet.getExtensionsAndNeuralLayersAndNeuralInputs().add(finalOuts);
        pmml.getAssociationModelsAndBaselineModelsAndClusteringModels().add(nnet);
        return pmml;
    }
}

