/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.TestState;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class TestClassUsages
implements Serializable {
    private final Map<ClassAndMethod, Set<String>> classNames = new HashMap<ClassAndMethod, Set<String>>();

    public synchronized void updateTestData(String currentclass, UniqueId test, Set<String> touched) {
        this.classNames.put(new ClassAndMethod(currentclass, test), touched);
    }

    public synchronized void updateTestData(String currentclass, Set<String> touched) {
        this.classNames.put(new ClassAndMethod(currentclass, null), touched);
    }

    public synchronized void merge(TestClassUsages newData) {
        this.classNames.putAll(newData.classNames);
    }

    public synchronized PostDiscoveryFilter getTestsToRun(final Set<String> changedClasses, final TestState testState) {
        final HashSet<UniqueId> touchedIds = new HashSet<UniqueId>();
        final HashSet<String> testClassesToRun = new HashSet<String>();
        block0: for (Map.Entry<ClassAndMethod, Set<String>> entry : this.classNames.entrySet()) {
            if (entry.getKey().uniqueId == null) continue;
            if (changedClasses.contains(entry.getKey().className)) {
                touchedIds.add(entry.getKey().uniqueId);
                testClassesToRun.add(entry.getKey().className);
                continue;
            }
            for (String i : changedClasses) {
                if (!entry.getValue().contains(i)) continue;
                touchedIds.add(entry.getKey().uniqueId);
                testClassesToRun.add(entry.getKey().className);
                continue block0;
            }
        }
        return new PostDiscoveryFilter(){

            public FilterResult apply(TestDescriptor testDescriptor) {
                if (testState.isFailed(testDescriptor)) {
                    return FilterResult.included((String)"Test failed previously");
                }
                if (testDescriptor.getSource().isEmpty()) {
                    return FilterResult.included((String)"No source information");
                }
                if (touchedIds.contains(testDescriptor.getUniqueId())) {
                    return FilterResult.included((String)"Class was touched");
                }
                TestSource source = (TestSource)testDescriptor.getSource().get();
                if (source instanceof ClassSource) {
                    String testClassName = ((ClassSource)source).getClassName();
                    ClassAndMethod cm = new ClassAndMethod(testClassName, null);
                    if (!TestClassUsages.this.classNames.containsKey(cm)) {
                        return FilterResult.included((String)"No test information");
                    }
                    if (changedClasses.contains(testClassName)) {
                        return FilterResult.included((String)"Test case was modified");
                    }
                    if (testClassesToRun.contains(testClassName)) {
                        return FilterResult.included((String)"Has at least one test");
                    }
                    return FilterResult.excluded((String)"Has no tests");
                }
                if (source instanceof MethodSource) {
                    MethodSource ms = (MethodSource)source;
                    ClassAndMethod cm = new ClassAndMethod(ms.getClassName(), testDescriptor.getUniqueId());
                    if (!TestClassUsages.this.classNames.containsKey(cm)) {
                        return FilterResult.included((String)"No test information");
                    }
                    if (changedClasses.contains(ms.getClassName())) {
                        return FilterResult.included((String)"Test case was modified");
                    }
                    if (touchedIds.contains(testDescriptor.getUniqueId())) {
                        return FilterResult.included((String)"Test touches changed classes");
                    }
                    return FilterResult.excluded((String)"Test does not need to run");
                }
                return FilterResult.included((String)"Unknown source type");
            }
        };
    }

    private static final class ClassAndMethod
    implements Serializable {
        private final String className;
        private final UniqueId uniqueId;

        private ClassAndMethod(String className, UniqueId uniqueId) {
            this.className = className;
            this.uniqueId = uniqueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAndMethod that = (ClassAndMethod)o;
            return Objects.equals(this.className, that.className) && Objects.equals(this.uniqueId, that.uniqueId);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.uniqueId);
        }

        public String getClassName() {
            return this.className;
        }

        public UniqueId getUniqueId() {
            return this.uniqueId;
        }
    }
}

