/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.logging;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;

public class LoggingWithPanacheProcessor {
    private static final DotName QUARKUS_LOG_DOTNAME = DotName.createSimple((String)"io.quarkus.logging.Log");
    private static final String QUARKUS_LOG_BINARY_NAME = "io/quarkus/logging/Log";
    private static final String SYNTHETIC_LOGGER_FIELD_NAME = "quarkusSyntheticLogger";
    private static final String JBOSS_LOGGER_BINARY_NAME = "org/jboss/logging/Logger";
    private static final String JBOSS_LOGGER_DESCRIPTOR = "Lorg/jboss/logging/Logger;";
    private static final String GET_LOGGER_DESCRIPTOR = "(Ljava/lang/String;)Lorg/jboss/logging/Logger;";

    @BuildStep
    public void process(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        for (ClassInfo clazz : index.getIndex().getKnownUsers(QUARKUS_LOG_DOTNAME)) {
            String className = clazz.name().toString();
            transformers.produce(new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setVisitorFunction((ignored, visitor) -> new AddLoggerFieldAndRewriteInvocations((ClassVisitor)visitor, className)).setClassReaderOptions(8).build());
        }
    }

    private static class AddLoggerFieldAndRewriteInvocations
    extends ClassVisitor {
        private final String className;
        private final String classNameBinary;
        private boolean generatedLoggerField;
        private boolean generatedLoggerFieldInitialization;

        public AddLoggerFieldAndRewriteInvocations(ClassVisitor visitor, String className) {
            super(589824, visitor);
            this.className = className;
            this.classNameBinary = className.replace(".", "/");
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (!this.generatedLoggerField) {
                this.generateLoggerField();
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        public MethodVisitor visitMethod(int access, final String name, String descriptor, String signature, String[] exceptions) {
            final MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (visitor == null) {
                return null;
            }
            return new LocalVariablesSorter(589824, access, descriptor, visitor){

                public void visitCode() {
                    if ("<clinit>".equals(name)) {
                        super.visitLdcInsn((Object)className);
                        super.visitMethodInsn(184, LoggingWithPanacheProcessor.JBOSS_LOGGER_BINARY_NAME, "getLogger", LoggingWithPanacheProcessor.GET_LOGGER_DESCRIPTOR, false);
                        super.visitFieldInsn(179, classNameBinary, LoggingWithPanacheProcessor.SYNTHETIC_LOGGER_FIELD_NAME, LoggingWithPanacheProcessor.JBOSS_LOGGER_DESCRIPTOR);
                        generatedLoggerFieldInitialization = true;
                    }
                    super.visitCode();
                }

                public void visitMethodInsn(int opcode, String owner, String name2, String descriptor, boolean isInterface) {
                    block6: {
                        int i;
                        int[] locals;
                        int numArgs;
                        Type[] argTypes;
                        block4: {
                            block5: {
                                if (!LoggingWithPanacheProcessor.QUARKUS_LOG_BINARY_NAME.equals(owner)) {
                                    super.visitMethodInsn(opcode, owner, name2, descriptor, isInterface);
                                    return;
                                }
                                argTypes = Type.getArgumentTypes((String)descriptor);
                                numArgs = argTypes.length;
                                locals = null;
                                boolean directStackManipulation = this.isDirectStackManipulationPossible(argTypes);
                                if (!directStackManipulation) {
                                    locals = new int[numArgs];
                                    for (i = numArgs - 1; i >= 0; --i) {
                                        locals[i] = this.newLocal(argTypes[i]);
                                        visitor.visitVarInsn(argTypes[i].getOpcode(54), locals[i]);
                                    }
                                }
                                super.visitFieldInsn(178, classNameBinary, LoggingWithPanacheProcessor.SYNTHETIC_LOGGER_FIELD_NAME, LoggingWithPanacheProcessor.JBOSS_LOGGER_DESCRIPTOR);
                                if (!directStackManipulation) break block4;
                                if (numArgs != 1) break block5;
                                super.visitInsn(95);
                                break block6;
                            }
                            if (numArgs != 2) break block6;
                            super.visitInsn(91);
                            super.visitInsn(87);
                            break block6;
                        }
                        for (i = 0; i < numArgs; ++i) {
                            visitor.visitVarInsn(argTypes[i].getOpcode(21), locals[i]);
                        }
                    }
                    super.visitMethodInsn(182, LoggingWithPanacheProcessor.JBOSS_LOGGER_BINARY_NAME, name2, descriptor, false);
                }

                private boolean isDirectStackManipulationPossible(Type[] argTypes) {
                    return argTypes.length == 0 || argTypes.length == 1 && argTypes[0].getSize() == 1 || argTypes.length == 2 && argTypes[0].getSize() == 1 && argTypes[1].getSize() == 1;
                }
            };
        }

        public void visitEnd() {
            if (!this.generatedLoggerField) {
                this.generateLoggerField();
            }
            if (!this.generatedLoggerFieldInitialization) {
                MethodVisitor visitor = super.visitMethod(8, "<clinit>", "()V", null, null);
                visitor.visitCode();
                visitor.visitLdcInsn((Object)this.className);
                visitor.visitMethodInsn(184, LoggingWithPanacheProcessor.JBOSS_LOGGER_BINARY_NAME, "getLogger", LoggingWithPanacheProcessor.GET_LOGGER_DESCRIPTOR, false);
                visitor.visitFieldInsn(179, this.classNameBinary, LoggingWithPanacheProcessor.SYNTHETIC_LOGGER_FIELD_NAME, LoggingWithPanacheProcessor.JBOSS_LOGGER_DESCRIPTOR);
                visitor.visitInsn(177);
                visitor.visitMaxs(1, 0);
                visitor.visitEnd();
                this.generatedLoggerFieldInitialization = true;
            }
            super.visitEnd();
        }

        private void generateLoggerField() {
            super.visitField(26, LoggingWithPanacheProcessor.SYNTHETIC_LOGGER_FIELD_NAME, LoggingWithPanacheProcessor.JBOSS_LOGGER_DESCRIPTOR, null, null);
            this.generatedLoggerField = true;
        }
    }
}

