/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api.buildplan;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileEntry {
    private final Path sourceFile;
    private final AbsoluteUnixPath extractionPath;
    private final FilePermissions permissions;
    private final Instant modificationTime;
    private final String ownership;

    public FileEntry(Path sourceFile, AbsoluteUnixPath extractionPath, FilePermissions permissions, Instant modificationTime) {
        this.sourceFile = sourceFile;
        this.extractionPath = extractionPath;
        this.permissions = permissions;
        this.modificationTime = modificationTime;
        this.ownership = "";
    }

    public FileEntry(Path sourceFile, AbsoluteUnixPath extractionPath, FilePermissions permissions, Instant modificationTime, String ownership) {
        this.sourceFile = sourceFile;
        this.extractionPath = extractionPath;
        this.permissions = permissions;
        this.modificationTime = modificationTime;
        this.ownership = ownership;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public AbsoluteUnixPath getExtractionPath() {
        return this.extractionPath;
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public String getOwnership() {
        return this.ownership;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileEntry)) {
            return false;
        }
        FileEntry otherFileEntry = (FileEntry)other;
        return this.sourceFile.equals(otherFileEntry.sourceFile) && this.extractionPath.equals(otherFileEntry.extractionPath) && this.permissions.equals(otherFileEntry.permissions) && this.modificationTime.equals(otherFileEntry.modificationTime) && this.ownership.equals(otherFileEntry.ownership);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.extractionPath, this.permissions, this.modificationTime, this.ownership);
    }
}

