/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.compiler.api.provider.ModelImplementationProviderFinder;
import org.kie.pmml.compiler.commons.implementations.ModelImplementationProviderFinderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLModelRetriever {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLModelRetriever.class.getName());
    private static final ModelImplementationProviderFinder modelImplementationProviderFinder = new ModelImplementationProviderFinderImpl();

    private KiePMMLModelRetriever() {
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModel(CompilationDTO compilationDTO) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModel {}", (Object)compilationDTO);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(compilationDTO.getPMML_MODEL()).map(implementation -> implementation.getKiePMMLModel(compilationDTO)).findFirst();
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSources(CompilationDTO compilationDTO) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSources {}", (Object)compilationDTO);
        Function<ModelImplementationProvider<Model, KiePMMLModel>, KiePMMLModel> modelFunction = implementation -> implementation.getKiePMMLModelWithSources(compilationDTO);
        return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon(compilationDTO.getFields(), compilationDTO.getModel(), modelFunction);
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled(CompilationDTO compilationDTO) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled {}", (Object)compilationDTO);
        Function<ModelImplementationProvider<Model, KiePMMLModel>, KiePMMLModel> modelFunction = implementation -> implementation.getKiePMMLModelWithSourcesCompiled(compilationDTO);
        return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon(compilationDTO.getFields(), compilationDTO.getModel(), modelFunction);
    }

    static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon(List<Field<?>> fields, Model model, Function<ModelImplementationProvider<Model, KiePMMLModel>, KiePMMLModel> modelFunction) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(pmmlMODEL).map(modelFunction).findFirst();
    }

    private static <T extends Model, E extends KiePMMLModel> Stream<ModelImplementationProvider<T, E>> getModelImplementationProviderStream(PMML_MODEL pmmlMODEL) {
        List implementations = modelImplementationProviderFinder.getImplementations(false);
        return implementations.stream().filter(implementation -> pmmlMODEL.equals((Object)implementation.getPMMLModelType()));
    }
}

