/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.boot.RuntimePersistenceUnitDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jboss.logging.Logger;

@Singleton
public class JPAConfig {
    private static final Logger LOGGER = Logger.getLogger((String)JPAConfig.class.getName());
    private final Map<String, LazyPersistenceUnit> persistenceUnits = new HashMap<String, LazyPersistenceUnit>();
    private final Set<String> deactivatedPersistenceUnitNames = new HashSet<String>();

    @Inject
    public JPAConfig(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig) {
        Map<String, HibernateOrmRuntimeConfigPersistenceUnit> puConfigMap = hibernateOrmRuntimeConfig.getAllPersistenceUnitConfigsAsMap();
        for (RuntimePersistenceUnitDescriptor descriptor : PersistenceUnitsHolder.getPersistenceUnitDescriptors()) {
            String puName = descriptor.getName();
            HibernateOrmRuntimeConfigPersistenceUnit puConfig = puConfigMap.getOrDefault(descriptor.getConfigurationName(), new HibernateOrmRuntimeConfigPersistenceUnit());
            if (puConfig.active.isPresent() && !puConfig.active.get().booleanValue()) {
                LOGGER.infof("Hibernate ORM persistence unit '%s' was deactivated through configuration properties", (Object)puName);
                this.deactivatedPersistenceUnitNames.add(puName);
                continue;
            }
            this.persistenceUnits.put(puName, new LazyPersistenceUnit(puName));
        }
    }

    void startAll() {
        ArrayList start = new ArrayList();
        for (final Map.Entry<String, LazyPersistenceUnit> entry : this.persistenceUnits.entrySet()) {
            final CompletableFuture future = new CompletableFuture();
            start.add(future);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((LazyPersistenceUnit)entry.getValue()).get();
                        future.complete(null);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                }
            }, "JPA Startup Thread: " + entry.getKey()).start();
        }
        for (CompletableFuture completableFuture : start) {
            try {
                completableFuture.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        LazyPersistenceUnit lazyPersistenceUnit = null;
        if (unitName == null) {
            if (this.persistenceUnits.size() == 1) {
                lazyPersistenceUnit = this.persistenceUnits.values().iterator().next();
            }
        } else {
            lazyPersistenceUnit = this.persistenceUnits.get(unitName);
        }
        if (lazyPersistenceUnit == null) {
            if (this.deactivatedPersistenceUnitNames.contains(unitName)) {
                throw new IllegalStateException("Cannot retrieve the EntityManagerFactory/SessionFactory for persistence unit " + unitName + ": Hibernate ORM was deactivated through configuration properties");
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find an EntityManagerFactory for persistence unit '%s'", unitName));
        }
        return lazyPersistenceUnit.get();
    }

    public Set<String> getPersistenceUnits() {
        return this.persistenceUnits.keySet();
    }

    public Set<String> getDeactivatedPersistenceUnitNames() {
        return this.deactivatedPersistenceUnitNames;
    }

    void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        for (LazyPersistenceUnit factory : this.persistenceUnits.values()) {
            try {
                factory.close();
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to close the EntityManagerFactory: " + factory), (Throwable)e);
            }
        }
    }

    @PreDestroy
    void destroy() {
        this.persistenceUnits.clear();
    }

    static final class LazyPersistenceUnit {
        private final String name;
        private volatile EntityManagerFactory value;
        private volatile boolean closed = false;

        LazyPersistenceUnit(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntityManagerFactory get() {
            if (this.value == null) {
                LazyPersistenceUnit lazyPersistenceUnit = this;
                synchronized (lazyPersistenceUnit) {
                    if (this.closed) {
                        throw new IllegalStateException("Persistence unit is closed");
                    }
                    if (this.value == null) {
                        this.value = Persistence.createEntityManagerFactory((String)this.name);
                    }
                }
            }
            return this.value;
        }

        public synchronized void close() {
            this.closed = true;
            EntityManagerFactory emf = this.value;
            this.value = null;
            if (emf != null) {
                emf.close();
            }
        }
    }
}

