/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.LockModeType;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.EnhancedEntity;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.kie.processmigration.model.Execution;
import org.kie.processmigration.model.MigrationDefinition;

@Entity
@Table(name="migrations")
public class Migration
extends PanacheEntityBase
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker,
EnhancedEntity,
CompositeOwner {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="migrationIdSeq")
    @SequenceGenerator(name="migrationIdSeq", sequenceName="MIGRATION_ID_SEQ")
    private Long id;
    @Embedded
    private MigrationDefinition definition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="created_at")
    private Instant createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="finished_at")
    private Instant finishedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="started_at")
    private Instant startedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="cancelled_at")
    private Instant cancelledAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="error_message")
    @Lob
    private String errorMessage;
    private Execution.ExecutionStatus status;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public Migration() {
    }

    public Migration(MigrationDefinition definition) {
        this.$$_hibernate_write_definition(definition);
        Instant now = Instant.now();
        this.$$_hibernate_write_createdAt(now);
        if (definition.getExecution() != null && Execution.ExecutionType.ASYNC.equals((Object)definition.getExecution().getType()) && definition.getExecution().getScheduledStartTime() != null && now.isBefore(definition.getExecution().getScheduledStartTime())) {
            this.$$_hibernate_write_status(Execution.ExecutionStatus.SCHEDULED);
        } else {
            this.$$_hibernate_write_status(Execution.ExecutionStatus.CREATED);
        }
    }

    public Migration start() {
        this.$$_hibernate_write_startedAt(Instant.now());
        this.$$_hibernate_write_status(Execution.ExecutionStatus.STARTED);
        return this;
    }

    public Migration complete(Boolean hasErrors) {
        this.$$_hibernate_write_finishedAt(Instant.now());
        if (Boolean.TRUE.equals(hasErrors)) {
            this.$$_hibernate_write_status(Execution.ExecutionStatus.FAILED);
        } else {
            this.$$_hibernate_write_status(Execution.ExecutionStatus.COMPLETED);
        }
        return this;
    }

    public Migration cancel() {
        this.$$_hibernate_write_cancelledAt(Instant.now());
        this.$$_hibernate_write_status(Execution.ExecutionStatus.CANCELLED);
        return this;
    }

    public Migration fail(Exception e) {
        this.$$_hibernate_write_finishedAt(Instant.now());
        this.$$_hibernate_write_status(Execution.ExecutionStatus.FAILED);
        this.$$_hibernate_write_errorMessage(e.toString());
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Migration)) {
            return false;
        }
        Migration other = (Migration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MigrationDefinition this$definition = this.getDefinition();
        MigrationDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$finishedAt = this.getFinishedAt();
        Instant other$finishedAt = other.getFinishedAt();
        if (this$finishedAt == null ? other$finishedAt != null : !((Object)this$finishedAt).equals(other$finishedAt)) {
            return false;
        }
        Instant this$startedAt = this.getStartedAt();
        Instant other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
            return false;
        }
        Instant this$cancelledAt = this.getCancelledAt();
        Instant other$cancelledAt = other.getCancelledAt();
        if (this$cancelledAt == null ? other$cancelledAt != null : !((Object)this$cancelledAt).equals(other$cancelledAt)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Execution.ExecutionStatus this$status = this.getStatus();
        Execution.ExecutionStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Migration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MigrationDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $finishedAt = this.getFinishedAt();
        result = result * 59 + ($finishedAt == null ? 43 : ((Object)$finishedAt).hashCode());
        Instant $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        Instant $cancelledAt = this.getCancelledAt();
        result = result * 59 + ($cancelledAt == null ? 43 : ((Object)$cancelledAt).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Execution.ExecutionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "Migration(id=" + this.getId() + ", definition=" + this.getDefinition() + ", createdAt=" + this.getCreatedAt() + ", finishedAt=" + this.getFinishedAt() + ", startedAt=" + this.getStartedAt() + ", cancelledAt=" + this.getCancelledAt() + ", errorMessage=" + this.getErrorMessage() + ", status=" + this.getStatus() + ")";
    }

    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public MigrationDefinition getDefinition() {
        return this.$$_hibernate_read_definition();
    }

    public Instant getCreatedAt() {
        return this.$$_hibernate_read_createdAt();
    }

    public Instant getFinishedAt() {
        return this.$$_hibernate_read_finishedAt();
    }

    public Instant getStartedAt() {
        return this.$$_hibernate_read_startedAt();
    }

    public Instant getCancelledAt() {
        return this.$$_hibernate_read_cancelledAt();
    }

    public String getErrorMessage() {
        return this.$$_hibernate_read_errorMessage();
    }

    public Execution.ExecutionStatus getStatus() {
        return this.$$_hibernate_read_status();
    }

    public Migration setId(Long id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public Migration setDefinition(MigrationDefinition definition) {
        this.$$_hibernate_write_definition(definition);
        return this;
    }

    public Migration setCreatedAt(Instant createdAt) {
        this.$$_hibernate_write_createdAt(createdAt);
        return this;
    }

    public Migration setFinishedAt(Instant finishedAt) {
        this.$$_hibernate_write_finishedAt(finishedAt);
        return this;
    }

    public Migration setStartedAt(Instant startedAt) {
        this.$$_hibernate_write_startedAt(startedAt);
        return this;
    }

    public Migration setCancelledAt(Instant cancelledAt) {
        this.$$_hibernate_write_cancelledAt(cancelledAt);
        return this;
    }

    public Migration setErrorMessage(String errorMessage) {
        this.$$_hibernate_write_errorMessage(errorMessage);
        return this;
    }

    public Migration setStatus(Execution.ExecutionStatus status) {
        this.$$_hibernate_write_status(status);
        return this;
    }

    public static /* synthetic */ long count() {
        return JpaOperations.INSTANCE.count(Migration.class);
    }

    public static /* synthetic */ long count(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.count(Migration.class, string, objectArray);
    }

    public static /* synthetic */ long count(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.count(Migration.class, string, parameters);
    }

    public static /* synthetic */ long count(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.count(Migration.class, string, map);
    }

    public static /* synthetic */ long delete(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.delete(Migration.class, string, objectArray);
    }

    public static /* synthetic */ long delete(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.delete(Migration.class, string, parameters);
    }

    public static /* synthetic */ long delete(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.delete(Migration.class, string, map);
    }

    public static /* synthetic */ long deleteAll() {
        return JpaOperations.INSTANCE.deleteAll(Migration.class);
    }

    public static /* synthetic */ boolean deleteById(Object object) {
        return JpaOperations.INSTANCE.deleteById(Migration.class, object);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Migration.class, string, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Migration.class, string, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Sort sort, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Migration.class, string, sort, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Sort sort, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Migration.class, string, sort, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Sort sort, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Migration.class, string, sort, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Migration.class, string, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> findAll() {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(Migration.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> findAll(Sort sort) {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(Migration.class, sort);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> T findById(Object object) {
        return (T)((PanacheEntityBase)JpaOperations.INSTANCE.findById(Migration.class, object));
    }

    public static /* synthetic */ <T extends PanacheEntityBase> T findById(Object object, LockModeType lockModeType) {
        return (T)((PanacheEntityBase)JpaOperations.INSTANCE.findById(Migration.class, object, lockModeType));
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Optional<T> findByIdOptional(Object object) {
        return JpaOperations.INSTANCE.findByIdOptional(Migration.class, object);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Optional<T> findByIdOptional(Object object, LockModeType lockModeType) {
        return JpaOperations.INSTANCE.findByIdOptional(Migration.class, object, lockModeType);
    }

    public static /* synthetic */ void flush() {
        JpaOperations.INSTANCE.flush(Migration.class);
    }

    public static /* synthetic */ EntityManager getEntityManager() {
        return JpaOperations.INSTANCE.getEntityManager(Migration.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(Migration.class, string, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.list(Migration.class, string, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(Migration.class, string, sort, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.list(Migration.class, string, sort, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(Migration.class, string, sort, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(Migration.class, string, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> listAll() {
        return JpaOperations.INSTANCE.listAll(Migration.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> listAll(Sort sort) {
        return JpaOperations.INSTANCE.listAll(Migration.class, sort);
    }

    public static /* synthetic */ void persist(Iterable<?> iterable) {
        PanacheEntityBase.persist(iterable);
    }

    public static /* synthetic */ void persist(Object object, Object[] objectArray) {
        PanacheEntityBase.persist(object, objectArray);
    }

    public static /* synthetic */ void persist(Stream<?> stream) {
        PanacheEntityBase.persist(stream);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(Migration.class, string, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(Migration.class, string, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(Migration.class, string, sort, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(Migration.class, string, sort, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(Migration.class, string, sort, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(Migration.class, string, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> streamAll() {
        return JpaOperations.INSTANCE.streamAll(Migration.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> streamAll(Sort sort) {
        return JpaOperations.INSTANCE.streamAll(Migration.class, sort);
    }

    public static /* synthetic */ int update(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.update(Migration.class, string, objectArray);
    }

    public static /* synthetic */ int update(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.update(Migration.class, string, parameters);
    }

    public static /* synthetic */ int update(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.update(Migration.class, string, map);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Migration migration = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        Migration migration = this;
        migration = null;
        migration = NoopCollectionTracker.INSTANCE;
        return migration;
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public MigrationDefinition $$_hibernate_read_definition() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.definition = (MigrationDefinition)this.$$_hibernate_getInterceptor().readObject((Object)this, "definition", (Object)this.definition);
        }
        return this.definition;
    }

    public void $$_hibernate_write_definition(MigrationDefinition migrationDefinition) {
        if (this.definition != null) {
            ((CompositeTracker)this.definition).$$_hibernate_clearOwner("definition");
        }
        Migration migration = this;
        MigrationDefinition migrationDefinition2 = migrationDefinition;
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)migration, (String)"definition", (Object)migrationDefinition2, (Object)migration.definition)) {
            migration.$$_hibernate_trackChange("definition");
        }
        migration.definition = migration.$$_hibernate_getInterceptor() != null ? (MigrationDefinition)migration.$$_hibernate_getInterceptor().writeObject((Object)migration, "definition", (Object)migration.definition, (Object)migrationDefinition2) : migrationDefinition2;
        if (this.definition != null) {
            ((CompositeTracker)this.definition).$$_hibernate_setOwner("definition", (CompositeOwner)this);
        }
        this.$$_hibernate_trackChange("definition");
    }

    public Instant $$_hibernate_read_createdAt() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdAt = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdAt", (Object)this.createdAt);
        }
        return this.createdAt;
    }

    public void $$_hibernate_write_createdAt(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdAt", (Object)instant, (Object)this.createdAt)) {
            this.$$_hibernate_trackChange("createdAt");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdAt = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdAt", (Object)this.createdAt, (Object)instant);
            return;
        }
        this.createdAt = instant;
    }

    public Instant $$_hibernate_read_finishedAt() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.finishedAt = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "finishedAt", (Object)this.finishedAt);
        }
        return this.finishedAt;
    }

    public void $$_hibernate_write_finishedAt(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"finishedAt", (Object)instant, (Object)this.finishedAt)) {
            this.$$_hibernate_trackChange("finishedAt");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.finishedAt = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "finishedAt", (Object)this.finishedAt, (Object)instant);
            return;
        }
        this.finishedAt = instant;
    }

    public Instant $$_hibernate_read_startedAt() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startedAt = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "startedAt", (Object)this.startedAt);
        }
        return this.startedAt;
    }

    public void $$_hibernate_write_startedAt(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"startedAt", (Object)instant, (Object)this.startedAt)) {
            this.$$_hibernate_trackChange("startedAt");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startedAt = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startedAt", (Object)this.startedAt, (Object)instant);
            return;
        }
        this.startedAt = instant;
    }

    public Instant $$_hibernate_read_cancelledAt() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.cancelledAt = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "cancelledAt", (Object)this.cancelledAt);
        }
        return this.cancelledAt;
    }

    public void $$_hibernate_write_cancelledAt(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"cancelledAt", (Object)instant, (Object)this.cancelledAt)) {
            this.$$_hibernate_trackChange("cancelledAt");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.cancelledAt = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "cancelledAt", (Object)this.cancelledAt, (Object)instant);
            return;
        }
        this.cancelledAt = instant;
    }

    public String $$_hibernate_read_errorMessage() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorMessage = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "errorMessage", (Object)this.errorMessage);
        }
        return this.errorMessage;
    }

    public void $$_hibernate_write_errorMessage(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"errorMessage", (Object)string, (Object)this.errorMessage)) {
            this.$$_hibernate_trackChange("errorMessage");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorMessage = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "errorMessage", (Object)this.errorMessage, (Object)string);
            return;
        }
        this.errorMessage = string;
    }

    public Execution.ExecutionStatus $$_hibernate_read_status() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (Execution.ExecutionStatus)this.$$_hibernate_getInterceptor().readObject((Object)this, "status", (Object)this.status);
        }
        return this.status;
    }

    public void $$_hibernate_write_status(Execution.ExecutionStatus executionStatus) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"status", (Object)executionStatus, (Object)this.status)) {
            this.$$_hibernate_trackChange("status");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (Execution.ExecutionStatus)this.$$_hibernate_getInterceptor().writeObject((Object)this, "status", (Object)this.status, (Object)executionStatus);
            return;
        }
        this.status = executionStatus;
    }
}

