/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

public enum AppOption {
    USAGE(new Settings("u", "usage", "Display usage", false, false, false, Settings.NO_GROUP)),
    HELP(new Settings("h", "help", "Display help", false, false, false, Settings.NO_GROUP)),
    LOG_QUIET(new Settings("q", "quiet", "Display quiet output: error level logging", false, false, false, "LOG_GROUP")),
    LOG_DEBUG(new Settings("v", "verbose", "Display verbose output: debug level logging", false, false, false, "LOG_GROUP")),
    LOG_TRACE(new Settings("x", "trace", "Display trace output: trace level logging", false, false, false, "LOG_GROUP")),
    LOG_PROPERTY(new Settings("lp", "logProperty", "Logging property", false, true, false, Settings.NO_GROUP)),
    LOG_PROPERTY_FILE(new Settings("lpf", "logPropertyFile", "Logging properties file", true, false, false, Settings.NO_GROUP)),
    LOG_NAME(new Settings("ln", "logName", "Logger name", true, false, false, Settings.NO_GROUP)),
    LOG_LEVEL(new Settings("ll", "logLevel", "Logging level", true, false, false, Settings.NO_GROUP)),
    LOG_FILE(new Settings("lf", "logFile", "Logging file", true, false, false, Settings.NO_GROUP)),
    RULES_SELECTIONS(new Settings("ts", "selection", "Transformation selections URL", true, false, false, Settings.NO_GROUP)),
    RULES_RENAMES(new Settings("tr", "renames", "Transformation package renames URL", true, false, false, Settings.NO_GROUP)),
    RULES_VERSIONS(new Settings("tv", "versions", "Transformation package versions URL", true, false, false, Settings.NO_GROUP)),
    RULES_BUNDLES(new Settings("tb", "bundles", "Transformation bundle updates URL", true, false, false, Settings.NO_GROUP)),
    RULES_DIRECT(new Settings("td", "direct", "Transformation direct string replacements", true, false, false, Settings.NO_GROUP)),
    RULES_MASTER_TEXT(new Settings("tf", "text", "Map of filenames to property files", true, false, false, Settings.NO_GROUP)),
    RULES_IMMEDIATE_DATA(new Settings("ti", "immediate", "Immediate rule data", false, false, true, 3, false, Settings.NO_GROUP)),
    WIDEN_ARCHIVE_NESTING(new Settings("w", "widen", "Widen archive nesting", false, false, false, Settings.NO_GROUP)),
    INVERT(new Settings("i", "invert", "Invert transformation rules", false, false, false, Settings.NO_GROUP)),
    FILE_TYPE(new Settings("t", "type", "Input file type", true, false, false, Settings.NO_GROUP)),
    OVERWRITE(new Settings("o", "overwrite", "Overwrite", false, false, false, Settings.NO_GROUP)),
    DRYRUN(new Settings("d", "dryrun", "Dry run", false, false, false, Settings.NO_GROUP)),
    RULES_PER_CLASS_CONSTANT(new Settings("tp", "per-class-constant", "Transformation per class constant string replacements", true, false, false, Settings.NO_GROUP));

    private final Settings settings;

    private AppOption(Settings settings) {
        this.settings = settings;
    }

    public String getShortTag() {
        return this.settings.getShortTag();
    }

    public String getLongTag() {
        return this.settings.getLongTag();
    }

    public String getDescription() {
        return this.settings.getDescription();
    }

    public boolean isRequired() {
        return this.settings.isRequired();
    }

    public boolean getHasArg() {
        return this.settings.getHasArg();
    }

    public boolean getHasArgs() {
        return this.settings.getHasArgs();
    }

    public boolean getHasArgCount() {
        return this.settings.getHasArgCount();
    }

    public int getArgCount() {
        return this.settings.getArgCount();
    }

    public String getGroupTag() {
        return this.settings.getGroupTag();
    }

    static class Settings {
        static final boolean HAS_ARG = true;
        static final boolean HAS_ARGS = true;
        static final boolean HAS_ARG_COUNT = true;
        static final boolean IS_REQUIRED = true;
        static final String NO_GROUP = null;
        private final String shortTag;
        private final String longTag;
        private final String description;
        private final boolean required;
        private final boolean hasArg;
        private final boolean hasArgs;
        private final boolean hasArgCount;
        private final int argCount;
        private final String groupTag;

        Settings(String shortTag, String longTag, String description, boolean hasArg, boolean hasArgs, boolean required, String groupTag) {
            this(shortTag, longTag, description, hasArg, hasArgs, false, -1, required, groupTag);
        }

        Settings(String shortTag, String longTag, String description, boolean hasArg, boolean hasArgs, boolean hasArgCount, int argCount, boolean required, String groupTag) {
            this.shortTag = shortTag;
            this.longTag = longTag;
            this.description = description;
            this.required = required;
            this.hasArg = hasArg;
            this.hasArgs = hasArgs;
            this.hasArgCount = hasArgCount;
            this.argCount = argCount;
            this.groupTag = groupTag;
        }

        String getShortTag() {
            return this.shortTag;
        }

        String getLongTag() {
            return this.longTag;
        }

        String getDescription() {
            return this.description;
        }

        boolean getHasArg() {
            return this.hasArg;
        }

        boolean getHasArgs() {
            return this.hasArgs;
        }

        boolean getHasArgCount() {
            return this.hasArgCount;
        }

        int getArgCount() {
            return this.argCount;
        }

        String getGroupTag() {
            return this.groupTag;
        }

        boolean isRequired() {
            return this.required;
        }
    }
}

