/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.transformer.AppOption;

public interface TransformOptions {
    default public boolean hasOption(AppOption option) {
        String result = this.getOptionValue(option);
        return Objects.nonNull(result);
    }

    default public String getOptionValue(AppOption option) {
        List<String> result = this.getOptionValues(option);
        return Objects.nonNull(result) && !result.isEmpty() ? result.get(0) : null;
    }

    default public List<String> getOptionValues(AppOption option) {
        return null;
    }

    default public String getDefaultValue(AppOption option) {
        return null;
    }

    default public Function<String, URL> getRuleLoader() {
        return this.getClass()::getResource;
    }

    default public String getInputFileName() {
        throw new UnsupportedOperationException("method not implemented");
    }

    default public String getOutputFileName() {
        throw new UnsupportedOperationException("method not implemented");
    }

    default public String normalize(String value) {
        return Objects.nonNull(value) ? value.replace(File.separatorChar, '/') : null;
    }

    default public List<String> normalize(List<String> values) {
        return Objects.nonNull(values) ? values.stream().map(this::normalize).collect(Collectors.toList()) : null;
    }
}

