/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

import aQute.bnd.exceptions.BiFunctionWithException;
import aQute.bnd.unmodifiable.Sets;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.uri.URIUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.transformer.AppOption;
import org.eclipse.transformer.ImmediateRuleData;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.TransformOptions;
import org.eclipse.transformer.TransformProperties;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionSelector;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.ContainerAction;
import org.eclipse.transformer.action.ContainerChanges;
import org.eclipse.transformer.action.SelectionRule;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.action.impl.ActionContextImpl;
import org.eclipse.transformer.action.impl.ActionSelectorImpl;
import org.eclipse.transformer.action.impl.BundleDataImpl;
import org.eclipse.transformer.action.impl.ClassActionImpl;
import org.eclipse.transformer.action.impl.DirectoryActionImpl;
import org.eclipse.transformer.action.impl.ElementActionImpl;
import org.eclipse.transformer.action.impl.JSPActionImpl;
import org.eclipse.transformer.action.impl.JavaActionImpl;
import org.eclipse.transformer.action.impl.ManifestActionImpl;
import org.eclipse.transformer.action.impl.PropertiesActionImpl;
import org.eclipse.transformer.action.impl.RenameActionImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.ServiceLoaderConfigActionImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.action.impl.TextActionImpl;
import org.eclipse.transformer.action.impl.XmlActionImpl;
import org.eclipse.transformer.action.impl.ZipActionImpl;
import org.eclipse.transformer.util.FileUtils;
import org.eclipse.transformer.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Transformer {
    public static final Marker consoleMarker = MarkerFactory.getMarker((String)"console");
    private final Logger logger;
    private final TransformOptions options;
    private URI base = IO.work.toURI();
    public Map<String, String> includes;
    public Map<String, String> excludes;
    public boolean invert;
    public Map<String, String> packageRenames;
    public Map<String, String> packageVersions;
    public Map<String, Map<String, String>> specificPackageVersions;
    public Map<String, BundleData> bundleUpdates;
    public Map<String, String> masterSubstitutionRefs;
    public Map<String, Map<String, String>> masterTextUpdates;
    public Map<String, String> directStrings;
    public boolean widenArchiveNesting;
    private ActionSelector actionSelector;
    public Action acceptedAction;
    public String inputName;
    public String inputPath;
    public File inputFile;
    public boolean allowOverwrite;
    public String outputName;
    public String outputPath;
    public File outputFile;
    public Map<String, Map<String, String>> perClassConstantStrings;
    public static final Set<AppOption> TARGETABLE_RULES = Sets.of((Object)((Object)AppOption.RULES_SELECTIONS), (Object)((Object)AppOption.RULES_RENAMES), (Object)((Object)AppOption.RULES_VERSIONS), (Object)((Object)AppOption.RULES_DIRECT), (Object)((Object)AppOption.RULES_PER_CLASS_CONSTANT), (Object)((Object)AppOption.RULES_BUNDLES), (Object)((Object)AppOption.RULES_MASTER_TEXT));
    private static final URI EMPTYURI = URI.create("");
    private SelectionRule selectionRules;
    private SignatureRule signatureRules;
    public static final String OUTPUT_PREFIX = "output_";

    public Transformer(TransformOptions options) {
        this(LoggerFactory.getLogger(Transformer.class), options);
    }

    public Transformer(Logger logger, TransformOptions options) {
        this.logger = Objects.requireNonNull(logger);
        this.options = Objects.requireNonNull(options);
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void logMerge(String sourceName, String sinkName, Object key, Object oldValue, Object newValue) {
        if (oldValue != null) {
            this.getLogger().debug(consoleMarker, "Merge of [ {} ] into [ {} ], key [ {} ] replaces value [ {} ] with [ {} ]", new Object[]{sourceName, sinkName, key, oldValue, newValue});
        }
    }

    public ResultCode run() {
        ResultCode rc = this.basicRun();
        this.getLogger().info(consoleMarker, "Transformer Return Code [ {} ] [ {} ]", (Object)rc.ordinal(), (Object)rc);
        return rc;
    }

    protected ResultCode basicRun() {
        boolean loadedRules;
        if (!this.setInput()) {
            return ResultCode.TRANSFORM_ERROR_RC;
        }
        if (!this.setOutput()) {
            return ResultCode.TRANSFORM_ERROR_RC;
        }
        try {
            loadedRules = this.setRules(this.getImmediateData());
        }
        catch (Exception e) {
            this.getLogger().error(consoleMarker, "Exception loading rules:", (Throwable)e);
            return ResultCode.RULES_ERROR_RC;
        }
        if (!loadedRules) {
            this.getLogger().error(consoleMarker, "Transformation rules cannot be used");
            return ResultCode.RULES_ERROR_RC;
        }
        this.logRules();
        if (!this.acceptAction()) {
            this.getLogger().error(consoleMarker, "No action selected");
            return ResultCode.FILE_TYPE_ERROR_RC;
        }
        try {
            this.transform();
        }
        catch (TransformException e) {
            this.getLogger().error(consoleMarker, "Transform failure", (Throwable)e);
            return ResultCode.TRANSFORM_ERROR_RC;
        }
        catch (Throwable th) {
            this.getLogger().error(consoleMarker, "Unexpected failure", th);
            return ResultCode.TRANSFORM_ERROR_RC;
        }
        Changes lastActiveChanges = this.getLastActiveChanges();
        if (lastActiveChanges instanceof ContainerChanges) {
            ContainerChanges containerChanges = (ContainerChanges)lastActiveChanges;
            int numDuplicated = containerChanges.getAllDuplicated();
            int numFailed = containerChanges.getAllFailed();
            if (numDuplicated != 0) {
                this.getLogger().warn("Duplicates were processed [ {} ]", (Object)numDuplicated);
            }
            if (numFailed != 0) {
                this.getLogger().warn("Failures were processed [ {} ]", (Object)numFailed);
                return ResultCode.TRANSFORM_ERROR_RC;
            }
        }
        return ResultCode.SUCCESS_RC;
    }

    public String getInputFileName() {
        return this.inputName;
    }

    public String getOutputFileName() {
        return this.outputName;
    }

    public AppOption getTargetOption(String targetText) {
        for (AppOption appOption : TARGETABLE_RULES) {
            if (targetText.equals(appOption.getLongTag())) {
                return appOption;
            }
            if (!targetText.equals(appOption.getShortTag())) continue;
            return appOption;
        }
        return null;
    }

    public ImmediateRuleData[] getImmediateData() {
        if (!this.options.hasOption(AppOption.RULES_IMMEDIATE_DATA)) {
            return new ImmediateRuleData[0];
        }
        List<String> immediateArgs = this.options.getOptionValues(AppOption.RULES_IMMEDIATE_DATA);
        if (immediateArgs.size() % 3 != 0) {
            this.getLogger().error(consoleMarker, "Incorrect number of arguments to option [ {} ] [ {} ]", (Object)AppOption.RULES_IMMEDIATE_DATA.getLongTag(), immediateArgs);
            return null;
        }
        int argCount = immediateArgs.size() / 3;
        ImmediateRuleData[] immediateData = new ImmediateRuleData[argCount];
        for (int argNo = 0; argNo < argCount; ++argNo) {
            int baseNo = argNo * 3;
            String targetText = immediateArgs.get(baseNo);
            String key = immediateArgs.get(baseNo + 1);
            String value = immediateArgs.get(baseNo + 2);
            this.getLogger().info(consoleMarker, "Immediate rule data specified; target [ {} ], key [ {} ], value [ {} ]", new Object[]{targetText, key, value});
            AppOption target = this.getTargetOption(targetText);
            if (target == null) {
                this.getLogger().error(consoleMarker, "Immediate rules target [ {} ] is not valid.", (Object)targetText);
                return null;
            }
            immediateData[argNo] = new ImmediateRuleData(target, key, value);
        }
        return immediateData;
    }

    public boolean setRules(ImmediateRuleData[] immediateData) throws Exception {
        String masterTextRef;
        if (immediateData == null) {
            return false;
        }
        HashSet<String> orphanedFinalPackages = new HashSet<String>();
        Map<String, String> selectionProperties = this.loadProperties(AppOption.RULES_SELECTIONS, null);
        Map<String, String> renameProperties = this.loadProperties(AppOption.RULES_RENAMES, orphanedFinalPackages);
        Map<String, String> versionProperties = this.loadProperties(AppOption.RULES_VERSIONS, null);
        Map<String, String> updateProperties = this.loadProperties(AppOption.RULES_BUNDLES, null);
        Map<String, String> directProperties = this.loadProperties(AppOption.RULES_DIRECT, null);
        Map<String, String> textMasterProperties = this.loadProperties(AppOption.RULES_MASTER_TEXT, null);
        Map<String, String> perClassConstantProperties = this.loadProperties(AppOption.RULES_PER_CLASS_CONSTANT, null);
        this.invert = this.options.hasOption(AppOption.INVERT);
        if (!selectionProperties.isEmpty()) {
            this.includes = new HashMap<String, String>();
            this.excludes = new HashMap<String, String>();
            TransformProperties.addSelections(this.includes, this.excludes, selectionProperties);
            this.getLogger().info(consoleMarker, "Selection rules are in use");
        } else {
            this.includes = null;
            this.excludes = null;
        }
        if (!renameProperties.isEmpty()) {
            if (this.invert) {
                renameProperties = TransformProperties.invert(renameProperties);
            }
            this.packageRenames = renameProperties;
            this.getLogger().info(consoleMarker, "Package renames are in use");
        } else {
            this.packageRenames = null;
        }
        if (!versionProperties.isEmpty()) {
            this.packageVersions = new HashMap<String, String>(versionProperties.size());
            this.specificPackageVersions = new HashMap<String, Map<String, String>>();
            TransformProperties.setPackageVersions(versionProperties, this.packageVersions, this.specificPackageVersions);
            this.getLogger().info(consoleMarker, "Package versions will be updated");
        } else {
            this.packageVersions = null;
            this.specificPackageVersions = null;
        }
        if (!updateProperties.isEmpty()) {
            this.bundleUpdates = TransformProperties.getBundleUpdates(updateProperties);
            this.getLogger().info(consoleMarker, "Bundle identities will be updated");
        } else {
            this.bundleUpdates = null;
        }
        if (!textMasterProperties.isEmpty()) {
            masterTextRef = this.options.normalize(this.options.getOptionValue(AppOption.RULES_MASTER_TEXT));
            HashMap<String, Map<String, String>> masterUpdates = new HashMap<String, Map<String, String>>();
            for (Map.Entry<String, String> substitutionRefEntry : textMasterProperties.entrySet()) {
                String simpleNameSelector = substitutionRefEntry.getKey();
                String substitutionsRef = this.options.normalize(substitutionRefEntry.getValue());
                Map<String, String> substitutions = this.loadSubstitutions(masterTextRef, simpleNameSelector, substitutionsRef);
                if (this.invert) {
                    substitutions = TransformProperties.invert(substitutions);
                }
                textMasterProperties.put(simpleNameSelector, substitutionsRef);
                masterUpdates.put(simpleNameSelector, substitutions);
            }
            this.masterSubstitutionRefs = textMasterProperties;
            this.masterTextUpdates = masterUpdates;
            this.getLogger().info(consoleMarker, "Text files will be updated");
        } else {
            masterTextRef = null;
            this.masterTextUpdates = null;
        }
        if (!directProperties.isEmpty()) {
            if (this.invert) {
                directProperties = TransformProperties.invert(directProperties);
            }
            this.directStrings = directProperties;
            this.getLogger().info(consoleMarker, "Java direct string updates will be performed");
        } else {
            this.directStrings = null;
            this.getLogger().debug(consoleMarker, "Java direct string updates will not be performed");
        }
        if (!perClassConstantProperties.isEmpty()) {
            String masterDirect = this.options.normalize(this.options.getOptionValue(AppOption.RULES_PER_CLASS_CONSTANT));
            HashMap<String, Map<String, String>> masterUpdates = new HashMap<String, Map<String, String>>();
            for (Map.Entry<String, String> substitutionRefEntry : perClassConstantProperties.entrySet()) {
                String classSelector = substitutionRefEntry.getKey();
                String substitutionsRef = this.options.normalize(substitutionRefEntry.getValue());
                Map<String, String> substitutions = this.loadSubstitutions(masterDirect, classSelector, substitutionsRef);
                if (this.invert) {
                    substitutions = TransformProperties.invert(substitutions);
                }
                masterUpdates.put(classSelector, substitutions);
            }
            this.perClassConstantStrings = masterUpdates;
            this.getLogger().info(consoleMarker, "Per class constant mapping files are enabled");
        } else {
            this.perClassConstantStrings = null;
            this.getLogger().debug(consoleMarker, "Per class constant mapping files are not enabled");
        }
        this.processImmediateData(immediateData, masterTextRef, orphanedFinalPackages);
        if (this.includes == null) {
            this.getLogger().info(consoleMarker, "All resources will be selected");
        }
        if (this.packageRenames == null) {
            this.getLogger().debug(consoleMarker, "Packages will not be renamed");
        }
        if (this.packageVersions == null) {
            this.getLogger().debug(consoleMarker, "Package versions will not be updated");
        }
        if (this.bundleUpdates == null) {
            this.getLogger().debug(consoleMarker, "Bundle identities will not be updated");
        }
        if (this.masterTextUpdates == null) {
            this.getLogger().debug(consoleMarker, "Text files will not be updated");
        }
        if (this.directStrings == null) {
            this.getLogger().debug(consoleMarker, "Java direct string updates will not be performed");
        }
        if (this.perClassConstantStrings == null) {
            this.getLogger().debug(consoleMarker, "Per class constant mapping files are not enabled");
        }
        return this.validateVersionUpdates(orphanedFinalPackages);
    }

    protected void processImmediateData(ImmediateRuleData[] immediateData, String masterTextRef, Set<String> orphanedFinalVersions) throws IOException, URISyntaxException {
        block8: for (ImmediateRuleData nextData : immediateData) {
            switch (nextData.target) {
                case RULES_SELECTIONS: {
                    this.addImmediateSelection(nextData.key, nextData.value);
                    continue block8;
                }
                case RULES_RENAMES: {
                    this.addImmediateRename(nextData.key, nextData.value, orphanedFinalVersions);
                    continue block8;
                }
                case RULES_VERSIONS: {
                    this.addImmediateVersion(nextData.key, nextData.value);
                    continue block8;
                }
                case RULES_BUNDLES: {
                    this.addImmediateBundleData(nextData.key, nextData.value);
                    continue block8;
                }
                case RULES_DIRECT: {
                    this.addImmediateDirect(nextData.key, nextData.value);
                    continue block8;
                }
                case RULES_MASTER_TEXT: {
                    this.addImmediateMasterText(masterTextRef, nextData.key, nextData.value);
                    continue block8;
                }
                default: {
                    this.getLogger().error(consoleMarker, "Unrecognized immediate data target [ {} ]", (Object)nextData.target);
                }
            }
        }
    }

    private void addImmediateSelection(String selection, String charset) {
        if (this.includes == null) {
            this.includes = new HashMap<String, String>();
            this.includes.put("*", FileUtils.DEFAULT_CHARSET.name());
            this.excludes = new HashMap<String, String>();
            this.getLogger().info(consoleMarker, "Selection rules use forced by immediate data");
        }
        TransformProperties.addSelection(this.includes, this.excludes, selection, charset);
    }

    private void addImmediateRename(String initialPackageName, String finalPackageName, Set<String> orphanedFinalPackages) {
        if (this.packageRenames == null) {
            this.packageRenames = new HashMap<String, String>();
            this.getLogger().info(consoleMarker, "Package renames forced by immediate data.");
        }
        if (this.invert) {
            String initialHold = initialPackageName;
            initialPackageName = finalPackageName;
            finalPackageName = initialHold;
        }
        String oldFinalPackageName = this.packageRenames.put(initialPackageName, finalPackageName);
        this.processOrphan("immediate rename data", "renameData", initialPackageName, oldFinalPackageName, finalPackageName, orphanedFinalPackages);
        this.logMerge("immediate rename data", "rename data", initialPackageName, oldFinalPackageName, finalPackageName);
    }

    private void addImmediateVersion(String finalPackageName, String versionText) {
        if (this.packageVersions == null) {
            this.packageVersions = new HashMap<String, String>();
            this.specificPackageVersions = new HashMap<String, Map<String, String>>();
            this.getLogger().info(consoleMarker, "Package version updates forced by immediate data.");
        }
        TransformProperties.setPackageVersions(finalPackageName, versionText, this.packageVersions, this.specificPackageVersions);
    }

    private void addImmediateBundleData(String bundleId, String value) {
        BundleDataImpl newBundleData;
        BundleData oldBundleData;
        if (this.bundleUpdates == null) {
            this.bundleUpdates = new HashMap<String, BundleData>();
            this.getLogger().info(consoleMarker, "Bundle identity updates forced by immediate data.");
        }
        if ((oldBundleData = this.bundleUpdates.put(bundleId, newBundleData = new BundleDataImpl(value))) != null) {
            this.logMerge("immediate bundle data", "bundle data", bundleId, oldBundleData.getPrintString(), newBundleData.getPrintString());
        }
    }

    private void addImmediateDirect(String initialText, String finalText) {
        String oldFinalText;
        if (this.directStrings == null) {
            this.directStrings = new HashMap<String, String>();
            this.getLogger().info(consoleMarker, "Java direct string updates forced by immediate data");
        }
        if ((oldFinalText = this.directStrings.put(initialText, finalText)) != null) {
            this.logMerge("immediate direct string data", "direct string data", initialText, oldFinalText, finalText);
        }
    }

    public Map<String, String> loadProperties(AppOption ruleOption, Set<String> orphanedValues) throws IOException, URISyntaxException {
        List<String> rulesReferences = this.options.normalize(this.options.getOptionValues(ruleOption));
        if (rulesReferences == null) {
            String rulesReference = this.options.getDefaultValue(ruleOption);
            if (rulesReference == null) {
                this.getLogger().debug(consoleMarker, "Skipping option [ {} ]", (Object)ruleOption);
                rulesReferences = Collections.emptyList();
            } else {
                rulesReferences = Collections.singletonList(rulesReference);
            }
        }
        if (rulesReferences.isEmpty()) {
            return new HashMap<String, String>();
        }
        String referenceName = ruleOption.name();
        String baseReference = rulesReferences.get(0);
        Map mergedProperties = rulesReferences.stream().reduce(new HashMap(), BiFunctionWithException.asBiFunction((props, ref) -> {
            Properties p = this.loadProperties0(referenceName, (String)ref);
            this.merge(baseReference, (Map<String, String>)props, (String)ref, p, orphanedValues);
            return props;
        }), (props1, props2) -> {
            props1.putAll(props2);
            return props1;
        });
        return mergedProperties;
    }

    String relativize(String relativeRef, String baseRef) throws URISyntaxException {
        URI baseURI = URIUtil.resolve((URI)EMPTYURI, (String)baseRef);
        URI resolved = URIUtil.resolve((URI)baseURI, (String)relativeRef);
        return resolved.toString();
    }

    protected Properties loadProperties0(String referenceName, String reference) throws URISyntaxException, IOException {
        URL url;
        URI uri = URIUtil.resolve((URI)EMPTYURI, (String)reference);
        if (uri.isAbsolute()) {
            url = uri.toURL();
        } else {
            URI fileUri = this.getBase().resolve(uri);
            if (Files.exists(Paths.get(fileUri), new LinkOption[0])) {
                url = fileUri.toURL();
            } else {
                url = this.options.getRuleLoader().apply(reference);
                if (url == null) {
                    this.getLogger().debug(consoleMarker, "Resource [ {} ] was not found [ {} ]", (Object)reference, (Object)referenceName);
                    throw new IOException("Resource [ " + reference + " ] not found on [ " + this.options.getRuleLoader() + " ]");
                }
            }
        }
        this.getLogger().info(consoleMarker, "Properties [ {} ] URL [ {} ]", (Object)referenceName, (Object)url);
        return PropertiesUtils.loadProperties(url);
    }

    protected void merge(String sinkName, Map<String, String> sink, String sourceName, Properties source, Set<String> orphanedValues) {
        for (Map.Entry<Object, Object> sourceEntry : source.entrySet()) {
            String key = (String)sourceEntry.getKey();
            String newValue = (String)sourceEntry.getValue();
            String oldValue = sink.put(key, newValue);
            if (orphanedValues != null) {
                this.processOrphan(sourceName, sinkName, key, oldValue, newValue, orphanedValues);
            }
            this.logMerge(sourceName, sinkName, key, oldValue, newValue);
        }
    }

    protected void processOrphan(String sourceName, String sinkName, String key, String oldValue, String newValue, Set<String> orphans) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (oldValue != null) {
            this.getLogger().debug(consoleMarker, "Merge of [ {} ] into [ {} ], key [ {} ] orphans [ {} ]", new Object[]{sourceName, sinkName, key, oldValue});
            orphans.add(oldValue);
        }
        if (orphans.remove(newValue)) {
            this.getLogger().debug(consoleMarker, "Merge of [ {} ] into [ {} ], key [ {} ] un-orphans [ {} ]", new Object[]{sourceName, sinkName, key, newValue});
        }
    }

    private Map<String, String> loadSubstitutions(String masterRef, String selector, String substitutionsRef) throws IOException, URISyntaxException {
        String referenceName = "Substitutions matching [ " + selector + " ]";
        List substitutionsRefs = Strings.split((String)substitutionsRef);
        Map substitutions = substitutionsRefs.stream().reduce(new HashMap(), BiFunctionWithException.asBiFunction((props, ref) -> {
            String relativeSubstitutionsRef;
            String string = relativeSubstitutionsRef = masterRef != null ? this.relativize((String)ref, masterRef) : ref;
            if (!relativeSubstitutionsRef.equals(ref)) {
                this.getLogger().debug(consoleMarker, "Adjusted substition reference from [ {} ] to [ {} ]", ref, (Object)relativeSubstitutionsRef);
            }
            Properties p = this.loadProperties0(referenceName, relativeSubstitutionsRef);
            return TransformProperties.copyPropertiesToMap(p, props);
        }), (props1, props2) -> {
            props1.putAll(props2);
            return props1;
        });
        return substitutions;
    }

    private void addImmediateMasterText(String masterTextRef, String simpleNameSelector, String substitutionsRef) throws IOException, URISyntaxException {
        if (this.masterTextUpdates == null) {
            this.masterTextUpdates = new HashMap<String, Map<String, String>>();
            this.getLogger().info(consoleMarker, "Text files updates forced by immediate data.");
        }
        substitutionsRef = this.options.normalize(substitutionsRef);
        Map<String, String> substitutionsMap = this.loadSubstitutions(masterTextRef, simpleNameSelector, substitutionsRef);
        String oldSubstitutionsRef = this.masterSubstitutionRefs.put(simpleNameSelector, substitutionsRef);
        Map<String, String> oldSubstitutionMap = this.masterTextUpdates.put(simpleNameSelector, substitutionsMap);
        if (oldSubstitutionsRef != null) {
            this.logMerge("immediate master text data", "master text data", simpleNameSelector, oldSubstitutionsRef, substitutionsRef);
        }
    }

    protected boolean validateVersionUpdates(Set<String> orphanedFinalPackages) {
        if ((this.packageVersions == null || this.packageVersions.isEmpty()) && (this.specificPackageVersions == null || this.specificPackageVersions.isEmpty())) {
            return true;
        }
        if (this.packageRenames == null || this.packageRenames.isEmpty()) {
            this.getLogger().error(consoleMarker, "Package version updates were specified but no package renames were specified.");
            return false;
        }
        boolean missingFinalPackages = !this.validateVersionUpdates(this.packageVersions, orphanedFinalPackages);
        for (Map.Entry<String, Map<String, String>> specificEntry : this.specificPackageVersions.entrySet()) {
            String attributeName = specificEntry.getKey();
            Map<String, String> updatesForAttribute = specificEntry.getValue();
            if (this.validateVersionUpdates(updatesForAttribute, orphanedFinalPackages)) continue;
            missingFinalPackages = true;
        }
        HashSet<String> ignoredAttributes = null;
        for (String attributeName : this.specificPackageVersions.keySet()) {
            if (ManifestActionImpl.selectAttribute(attributeName)) continue;
            if (ignoredAttributes == null) {
                ignoredAttributes = new HashSet<String>();
            }
            ignoredAttributes.add(attributeName);
        }
        if (ignoredAttributes != null) {
            this.getLogger().info(consoleMarker, "Warning: Ignoring unknown attributes {} used for specific package version updates.", ignoredAttributes);
        }
        return !missingFinalPackages;
    }

    protected boolean validateVersionUpdates(Map<String, String> versionUpdates, Set<String> orphanedFinalPackages) {
        boolean isValid = true;
        for (String finalPackage : versionUpdates.keySet()) {
            if (this.validateVersionUpdate(finalPackage, orphanedFinalPackages)) continue;
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateVersionUpdate(String finalPackage, Set<String> orphanedFinalPackages) {
        if (this.packageRenames.containsValue(finalPackage)) {
            return true;
        }
        if (orphanedFinalPackages.contains(finalPackage)) {
            this.getLogger().info(consoleMarker, "Package [ {} ] has a version update but was orphaned.", (Object)finalPackage);
            return true;
        }
        this.getLogger().info(consoleMarker, "Package [ {} ] has a version update but was not renamed.", (Object)finalPackage);
        return true;
    }

    public void logRules() {
        if (!this.getLogger().isDebugEnabled()) {
            return;
        }
        this.getLogger().debug("Includes:");
        if (this.includes == null || this.includes.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            this.includes.forEach((include, charset) -> this.getLogger().debug("  [ {} ] [ {} ]", include, charset));
        }
        this.getLogger().debug("Excludes:");
        if (this.excludes == null || this.excludes.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            for (String string : this.excludes.keySet()) {
                this.getLogger().debug("  [ {} ]", (Object)string);
            }
        }
        if (this.invert) {
            this.getLogger().debug("Package Renames: [ ** INVERTED ** ]");
        } else {
            this.getLogger().debug("Package Renames:");
        }
        if (this.packageRenames == null || this.packageRenames.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            for (Map.Entry entry : this.packageRenames.entrySet()) {
                this.getLogger().debug("  [ {} ]: [ {} ]", entry.getKey(), entry.getValue());
            }
        }
        this.getLogger().debug("Package Versions:");
        if (this.packageVersions == null || this.packageVersions.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            for (Map.Entry entry : this.packageVersions.entrySet()) {
                this.getLogger().debug("  [ {} ]: [ {} ]", entry.getKey(), entry.getValue());
            }
        }
        this.getLogger().debug("Bundle Updates:");
        if (this.bundleUpdates == null || this.bundleUpdates.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            for (Map.Entry entry : this.bundleUpdates.entrySet()) {
                BundleData updateData = (BundleData)entry.getValue();
                this.getLogger().debug("  [ {} ]: [ {} ]", entry.getKey(), (Object)updateData.getSymbolicName());
                this.getLogger().debug("    [ Version ]: [ {} ]", (Object)updateData.getVersion());
                if (updateData.getAddName()) {
                    this.getLogger().debug("    [ Name ]: [ +{} ]", (Object)updateData.getName());
                } else {
                    this.getLogger().debug("    [ Name ]: [ {} ]", (Object)updateData.getName());
                }
                if (updateData.getAddDescription()) {
                    this.getLogger().debug("    [ Description ]: [ +{} ]", (Object)updateData.getDescription());
                    continue;
                }
                this.getLogger().debug("    [ Description ]: [ {} ]", (Object)updateData.getDescription());
            }
        }
        this.getLogger().debug("Java string substitutions:");
        if (this.directStrings == null || this.directStrings.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            for (Map.Entry entry : this.directStrings.entrySet()) {
                this.getLogger().debug("  [ {} ]: [ {} ]", entry.getKey(), entry.getValue());
            }
        }
        this.getLogger().debug("Text substitutions:");
        if (this.masterTextUpdates == null || this.masterTextUpdates.isEmpty()) {
            this.getLogger().debug("  [ ** NONE ** ]");
        } else {
            for (Map.Entry entry : this.masterTextUpdates.entrySet()) {
                this.getLogger().debug("  Pattern [ {} ]", entry.getKey());
                for (Map.Entry substitution : ((Map)entry.getValue()).entrySet()) {
                    this.getLogger().debug("    [ {} ]: [ {} ]", substitution.getKey(), substitution.getValue());
                }
            }
        }
    }

    public SelectionRule getSelectionRule() {
        if (this.selectionRules == null) {
            this.selectionRules = new SelectionRuleImpl(this.getLogger(), this.includes, this.excludes);
        }
        return this.selectionRules;
    }

    public SignatureRule getSignatureRule() {
        if (this.signatureRules == null) {
            this.signatureRules = new SignatureRuleImpl(this.getLogger(), this.packageRenames, this.packageVersions, this.specificPackageVersions, this.bundleUpdates, this.masterTextUpdates, this.directStrings, this.perClassConstantStrings);
        }
        return this.signatureRules;
    }

    public boolean setInput() {
        String useInputName = this.options.getInputFileName();
        if (useInputName == null) {
            this.getLogger().error(consoleMarker, "No input file was specified");
            return false;
        }
        this.inputName = this.options.normalize(useInputName);
        this.inputFile = new File(this.inputName);
        this.inputPath = this.inputFile.getAbsolutePath();
        if (!this.inputFile.exists()) {
            this.getLogger().error(consoleMarker, "Input does not exist [ {} ] [ {} ]", (Object)this.inputName, (Object)this.inputPath);
            return false;
        }
        try {
            this.inputFile = this.inputFile.getCanonicalFile();
            this.inputPath = this.inputFile.getAbsolutePath();
        }
        catch (IOException e) {
            this.getLogger().error(consoleMarker, "Input error [ {} ] [ {} ] ", new Object[]{this.inputName, e.toString(), e});
            return false;
        }
        if (this.inputFile.getParent() == null) {
            this.getLogger().error(consoleMarker, "Input directory is invalid. Don't designate the top directory. [ {} ] [ {} ]", (Object)this.inputName, (Object)this.inputPath);
            return false;
        }
        this.getLogger().debug(consoleMarker, "Input [ {} ]", (Object)this.inputName);
        this.getLogger().info(consoleMarker, "Input [ {} ]", (Object)this.inputPath);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setOutput() {
        boolean putIntoDirectory;
        boolean isExplicit;
        String useOutputName = this.options.getOutputFileName();
        boolean bl = isExplicit = useOutputName != null;
        if (isExplicit) {
            useOutputName = this.options.normalize(useOutputName);
        } else {
            File parent = this.inputFile.getParentFile();
            File output = new File(parent, OUTPUT_PREFIX + this.inputFile.getName());
            useOutputName = this.options.normalize(output.getAbsolutePath());
        }
        File useOutputFile = new File(useOutputName);
        String useOutputPath = null;
        try {
            useOutputFile = useOutputFile.getCanonicalFile();
            useOutputPath = useOutputFile.getAbsolutePath();
        }
        catch (IOException e) {
            this.getLogger().error(consoleMarker, "Output error [ {} ] [ {} ]", new Object[]{this.outputName, e.toString(), e});
            return false;
        }
        boolean bl2 = putIntoDirectory = this.inputFile.isFile() && useOutputFile.isDirectory();
        if (putIntoDirectory) {
            useOutputName = useOutputName + '/' + this.inputName;
            this.getLogger().debug(consoleMarker, "Output generated using input name and output directory [ {} ]", (Object)useOutputName);
            useOutputFile = new File(useOutputName);
            useOutputPath = useOutputFile.getAbsolutePath();
        }
        String outputCase = isExplicit ? (putIntoDirectory ? "Explicit directory" : "Explicit") : (putIntoDirectory ? "Directory generated from input" : "Generated from input");
        this.getLogger().debug(consoleMarker, "Output [ {} ] ({})", (Object)useOutputName, (Object)outputCase);
        this.getLogger().info(consoleMarker, "Output [ {} ]", (Object)useOutputPath);
        this.allowOverwrite = this.options.hasOption(AppOption.OVERWRITE);
        if (this.allowOverwrite) {
            this.getLogger().info(consoleMarker, "Overwrite of output is enabled");
        }
        if (this.outputExists(useOutputFile)) {
            if (!this.allowOverwrite) {
                this.getLogger().error(consoleMarker, "Output already exists [ {} ]", (Object)useOutputPath);
                return false;
            }
            this.getLogger().info(consoleMarker, "Output exists and will be overwritten [ {} ]", (Object)useOutputPath);
        } else if (this.allowOverwrite) {
            this.getLogger().debug(consoleMarker, "Overwritten specified, but output [ {} ] does not exist", (Object)useOutputPath);
        }
        this.outputName = useOutputName;
        this.outputFile = useOutputFile;
        this.outputPath = useOutputPath;
        if (this.outputPath.startsWith(this.inputPath + File.separator)) {
            this.getLogger().error(consoleMarker, "Output path is under input directory [ {} ]", (Object)useOutputPath);
            return false;
        }
        return true;
    }

    private boolean outputExists(File outputFile) {
        if (outputFile.isFile()) {
            return true;
        }
        if (outputFile.isDirectory()) {
            boolean bl;
            block10: {
                Stream<Path> stream = Files.list(outputFile.toPath());
                try {
                    bl = stream.findAny().isPresent();
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return true;
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public ActionContext getActionContext() {
        return new ActionContextImpl(this.getLogger(), this.getSelectionRule(), this.getSignatureRule());
    }

    public ActionSelector getActionSelector() {
        if (this.actionSelector == null) {
            ActionSelectorImpl useSelector = new ActionSelectorImpl();
            ActionContext context = this.getActionContext();
            ContainerAction directoryAction = useSelector.addUsing(DirectoryActionImpl::new, context);
            ClassActionImpl classAction = useSelector.addUsing(ClassActionImpl::new, context);
            JavaActionImpl javaAction = useSelector.addUsing(JavaActionImpl::new, context);
            JSPActionImpl jspAction = useSelector.addUsing(JSPActionImpl::new, context);
            ServiceLoaderConfigActionImpl serviceConfigAction = useSelector.addUsing(ServiceLoaderConfigActionImpl::new, context);
            ManifestActionImpl manifestAction = useSelector.addUsing(c -> new ManifestActionImpl((ActionContext)c, ActionType.MANIFEST), context);
            ManifestActionImpl featureAction = useSelector.addUsing(c -> new ManifestActionImpl((ActionContext)c, ActionType.FEATURE), context);
            TextActionImpl textAction = useSelector.addUsing(TextActionImpl::new, context);
            XmlActionImpl xmlAction = useSelector.addUsing(XmlActionImpl::new, context);
            PropertiesActionImpl propertiesAction = useSelector.addUsing(PropertiesActionImpl::new, context);
            ArrayList<ElementActionImpl> standardActions = new ArrayList<ElementActionImpl>();
            standardActions.add(classAction);
            standardActions.add(javaAction);
            standardActions.add(jspAction);
            standardActions.add(serviceConfigAction);
            standardActions.add(manifestAction);
            standardActions.add(featureAction);
            standardActions.add(textAction);
            standardActions.add(propertiesAction);
            standardActions.add(xmlAction);
            ContainerAction jarAction = useSelector.addUsing(c -> new ZipActionImpl((ActionContext)c, ActionType.JAR), context);
            ContainerAction warAction = useSelector.addUsing(c -> new ZipActionImpl((ActionContext)c, ActionType.WAR), context);
            ContainerAction rarAction = useSelector.addUsing(c -> new ZipActionImpl((ActionContext)c, ActionType.RAR), context);
            ContainerAction earAction = useSelector.addUsing(c -> new ZipActionImpl((ActionContext)c, ActionType.EAR), context);
            ContainerAction zipAction = useSelector.addUsing(c -> new ZipActionImpl((ActionContext)c, ActionType.ZIP), context);
            RenameActionImpl renameAction = useSelector.addUsing(RenameActionImpl::new, context);
            directoryAction.addActions(standardActions);
            directoryAction.addAction(zipAction);
            directoryAction.addAction(jarAction);
            directoryAction.addAction(warAction);
            directoryAction.addAction(rarAction);
            directoryAction.addAction(earAction);
            jarAction.addActions(standardActions);
            warAction.addActions(standardActions);
            warAction.addAction(jarAction);
            rarAction.addActions(standardActions);
            rarAction.addAction(jarAction);
            earAction.addAction(manifestAction);
            earAction.addAction(textAction);
            earAction.addAction(jarAction);
            earAction.addAction(warAction);
            earAction.addAction(rarAction);
            zipAction.addActions(standardActions);
            zipAction.addAction(jarAction);
            zipAction.addAction(warAction);
            zipAction.addAction(rarAction);
            zipAction.addAction(earAction);
            if (this.options.hasOption(AppOption.WIDEN_ARCHIVE_NESTING)) {
                this.getLogger().info(consoleMarker, "Widened action nesting is enabled.");
                jarAction.addAction(jarAction);
                jarAction.addAction(zipAction);
                rarAction.addAction(zipAction);
                warAction.addAction(zipAction);
                earAction.addAction(zipAction);
                zipAction.addAction(zipAction);
            }
            directoryAction.addAction(renameAction);
            jarAction.addAction(renameAction);
            warAction.addAction(renameAction);
            rarAction.addAction(renameAction);
            earAction.addAction(renameAction);
            zipAction.addAction(renameAction);
            this.actionSelector = useSelector;
        }
        return this.actionSelector;
    }

    public boolean acceptAction() {
        String actionName = this.options.getOptionValue(AppOption.FILE_TYPE);
        if (actionName != null) {
            this.acceptedAction = this.getActionSelector().acceptType(actionName);
            if (this.acceptedAction != null) {
                this.getLogger().info(consoleMarker, "Forced action [ {} ]", (Object)actionName);
                return true;
            }
            this.getLogger().error(consoleMarker, "No match for forced action [ {} ]", (Object)actionName);
            return false;
        }
        this.acceptedAction = this.getActionSelector().selectAction(this.inputName, this.inputFile);
        if (this.acceptedAction == null) {
            this.getLogger().error(consoleMarker, "No action selected for input [ {} ]", (Object)this.inputName);
            return false;
        }
        this.getLogger().info(consoleMarker, "Action selected for input [ {} ]: {}", (Object)this.inputName, (Object)this.acceptedAction.getName());
        return true;
    }

    public void transform() throws TransformException {
        this.acceptedAction.apply(this.inputName, this.inputFile, this.outputName, this.outputFile);
        this.acceptedAction.getLastActiveChanges().log(this.getLogger(), this.inputPath, this.outputPath);
    }

    public Changes getLastActiveChanges() {
        if (this.acceptedAction != null) {
            return this.acceptedAction.getLastActiveChanges();
        }
        return null;
    }

    public URI getBase() {
        return this.base;
    }

    public void setBase(URI base) {
        this.base = Objects.requireNonNull(base);
    }

    public static enum ResultCode {
        SUCCESS_RC("Success"),
        ARGS_ERROR_RC("Argument Error"),
        RULES_ERROR_RC("Rules Error"),
        TRANSFORM_ERROR_RC("Transform Error"),
        FILE_TYPE_ERROR_RC("File Type Error");

        private final String description;

        private ResultCode(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

