/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action;

import java.io.File;
import java.nio.charset.Charset;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.SelectionRule;
import org.eclipse.transformer.action.SignatureRule;

public interface Action {
    default public String getName() {
        return this.getActionType().getName();
    }

    public ActionType getActionType();

    default public boolean isElementAction() {
        return false;
    }

    default public boolean isContainerAction() {
        return false;
    }

    default public boolean isRenameAction() {
        return false;
    }

    default public boolean isArchiveAction() {
        return false;
    }

    default public boolean acceptResource(String resourceName) {
        return this.acceptResource(resourceName, null);
    }

    public boolean acceptResource(String var1, File var2);

    default public boolean acceptType(String actionTypeName) {
        return this.getActionType().matches(actionTypeName);
    }

    default public boolean selectResource(String resourceName) {
        return this.getResourceSelectionRule().select(resourceName);
    }

    default public Charset resourceCharset(String resourceName) {
        return this.getResourceSelectionRule().charset(resourceName);
    }

    public SignatureRule getSignatureRule();

    public SelectionRule getResourceSelectionRule();

    public void apply(String var1, File var2, String var3, File var4) throws TransformException;

    public void startRecording(String var1);

    default public String relocateResource(String inputPath) {
        return this.getSignatureRule().relocateResource(inputPath);
    }

    public void stopRecording(String var1);

    public Changes getLastActiveChanges();

    public Changes getActiveChanges();

    default public void setResourceNames(String inputResourceName, String outputResourceName) {
        this.getActiveChanges().setInputResourceName(inputResourceName).setOutputResourceName(outputResourceName);
    }

    default public boolean isChanged() {
        return this.getActiveChanges().isChanged();
    }

    default public boolean isContentChanged() {
        return this.getActiveChanges().isContentChanged();
    }

    default public boolean isRenamed() {
        return this.getActiveChanges().isRenamed();
    }
}

