/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.SelectionRule;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.util.FileUtils;
import org.slf4j.Logger;

public abstract class ActionImpl
implements Action {
    private final ActionContext context;
    private final Deque<Changes> changes;
    private Changes activeChanges;
    private Changes lastActiveChanges;
    public static final List<StringReplacement> NO_ACTIVE_REPLACEMENTS = Collections.emptyList();

    public ActionImpl(ActionContext context) {
        this.context = Objects.requireNonNull(context);
        this.changes = new ArrayDeque<Changes>();
        this.activeChanges = null;
        this.lastActiveChanges = null;
    }

    protected ActionContext getContext() {
        return this.context;
    }

    protected Logger getLogger() {
        return this.getContext().getLogger();
    }

    @Override
    public SelectionRule getResourceSelectionRule() {
        return this.getContext().getSelectionRule();
    }

    @Override
    public SignatureRule getSignatureRule() {
        return this.getContext().getSignatureRule();
    }

    public Map<String, String> getPackageRenames() {
        return this.getSignatureRule().getPackageRenames();
    }

    public String replacePackage(String initialName) {
        return this.getSignatureRule().replacePackage(initialName);
    }

    public String replaceBinaryPackage(String initialName) {
        return this.getSignatureRule().replaceBinaryPackage(initialName);
    }

    public String replacePackages(String initialText) {
        return this.getSignatureRule().replacePackages(initialText);
    }

    public String replaceBinaryPackages(String initialText) {
        return this.getSignatureRule().replaceBinaryPackages(initialText);
    }

    public String packageRenameInput(String inputName) {
        return this.getSignatureRule().packageRenameInput(inputName);
    }

    public String replacePackageVersion(String attributeName, String packageName, String oldVersion) {
        return this.getSignatureRule().replacePackageVersion(attributeName, packageName, oldVersion);
    }

    public BundleData getBundleUpdate(String symbolicName) {
        return this.getSignatureRule().getBundleUpdate(symbolicName);
    }

    public Map<String, String> getTextSubstitutions(String inputName) {
        return this.getSignatureRule().getTextSubstitutions(inputName);
    }

    public String replaceText(String inputFileName, String initialText) {
        return this.getSignatureRule().replaceText(inputFileName, initialText);
    }

    public String replaceTextDirectPerClass(String initialValue, String inputName) {
        return this.getSignatureRule().replaceTextDirectPerClass(initialValue, inputName);
    }

    public String replaceTextDirectGlobal(String initialValue, String inputName) {
        return this.getSignatureRule().replaceTextDirectGlobal(initialValue, inputName);
    }

    public String transformBinaryType(String inputConstant) {
        return this.getSignatureRule().transformBinaryType(inputConstant);
    }

    public String transformDescriptor(String inputConstant) {
        return this.getSignatureRule().transformDescriptor(inputConstant);
    }

    public String transformSignature(String initialSignature, SignatureRule.SignatureType signatureType) {
        return this.getSignatureRule().transformSignature(initialSignature, signatureType);
    }

    @Override
    public boolean acceptResource(String resourceName, File resourceFile) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support this method");
    }

    protected boolean matchResourceName(String resourceName) {
        return this.getActionType().resourceNameMatcher().test(resourceName);
    }

    protected abstract Changes newChanges();

    protected void startRecording(ByteData inputData) {
        this.startRecording(inputData.name());
    }

    protected void stopRecording(ByteData inputData) {
        this.stopRecording(inputData.name());
    }

    @Override
    public void startRecording(String inputName) {
        this.getLogger().debug("Start processing [ {} ] using [ {} ]", (Object)inputName, (Object)this.getName());
        Changes useActiveChanges = this.activeChanges;
        if (useActiveChanges != null) {
            this.changes.addLast(useActiveChanges);
        }
        this.activeChanges = this.newChanges();
    }

    @Override
    public void stopRecording(String inputName) {
        Changes useActiveChanges = this.activeChanges;
        Logger useLogger = this.getLogger();
        if (useLogger.isDebugEnabled()) {
            useLogger.debug("Stop processing [ {} ] using [ {} ]: {}", new Object[]{inputName, this.getName(), useActiveChanges.getChangeText()});
        }
        this.lastActiveChanges = useActiveChanges;
        this.activeChanges = this.changes.pollLast();
    }

    @Override
    public Changes getActiveChanges() {
        return this.activeChanges;
    }

    @Override
    public Changes getLastActiveChanges() {
        return this.lastActiveChanges;
    }

    public ByteData collect(String inputName, InputStream inputStream, int inputCount) throws TransformException {
        Charset charset = this.resourceCharset(inputName);
        try {
            return FileUtils.read(this.getLogger(), inputName, charset, inputStream, inputCount);
        }
        catch (IOException e) {
            throw new TransformException("Failed to read [ " + inputName + " ] count [ " + inputCount + " ]", e);
        }
    }

    public ByteData collect(String inputName, InputStream inputStream) throws TransformException {
        return this.collect(inputName, inputStream, -1);
    }

    public ByteData collect(String inputPath, File inputFile) throws TransformException {
        ByteData byteData;
        block8: {
            InputStream inputStream = IO.stream((File)inputFile);
            try {
                byteData = this.collect(inputPath, inputStream, Math.toIntExact(inputFile.length()));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TransformException("Failed to read input [ " + inputFile.getAbsolutePath() + " ]", e);
                }
            }
            inputStream.close();
        }
        return byteData;
    }

    protected void write(ByteData outputData, OutputStream outputStream) throws TransformException {
        try {
            outputData.writeTo(outputStream);
        }
        catch (IOException e) {
            throw new TransformException("Failed to write [ " + outputData + " ]");
        }
    }

    protected void writeInto(ByteData outputData, File outputFolder) throws TransformException {
        this.writeInto(outputData, outputFolder, outputData.name());
    }

    protected void writeInto(ByteData outputData, File outputFolder, String outputPath) throws TransformException {
        File outputFile;
        try {
            outputFile = IO.getBasedFile((File)outputFolder, (String)outputPath);
        }
        catch (IOException e) {
            throw new TransformException("Non-valid file [ " + outputFolder.getAbsolutePath() + " ] [ " + outputPath + " ]", e);
        }
        this.write(outputData, outputFile);
    }

    protected void write(ByteData outputData, File outputFile) {
        File parentFile = outputFile.getParentFile();
        try {
            IO.mkdirs((File)parentFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to create parent directory of [ " + outputFile.getAbsolutePath() + " ]", e);
        }
        try (OutputStream outputStream = IO.outputStream((File)outputFile);){
            this.write(outputData, outputStream);
        }
        catch (IOException e) {
            throw new TransformException("Failed to write [ " + outputFile.getAbsolutePath() + " ]", e);
        }
    }

    protected void copyInto(String inputPath, File inputFile, File outputFolder) throws TransformException {
        this.copyInto(inputPath, inputFile, outputFolder, inputPath);
    }

    protected void copyInto(String inputPath, File inputFile, File outputFolder, String outputPath) throws TransformException {
        File outputFile;
        try {
            outputFile = IO.getBasedFile((File)outputFolder, (String)outputPath);
        }
        catch (IOException e) {
            throw new TransformException("Non-valid file [ " + outputFolder.getAbsolutePath() + " ] [ " + outputPath + " ]", e);
        }
        File parentFile = outputFile.getParentFile();
        try {
            IO.mkdirs((File)parentFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to create parent directory of [ " + outputFile.getAbsolutePath() + " ]", e);
        }
        try {
            IO.copy((File)inputFile, (File)outputFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to copy [ " + inputFile.getAbsolutePath() + " ] to [ " + outputFile.getAbsolutePath() + " ]", e);
        }
    }

    protected List<StringReplacement> getActiveReplacements() {
        return NO_ACTIVE_REPLACEMENTS;
    }

    protected boolean allowMultipleReplacements() {
        return true;
    }

    protected String updateString(String inputName, String valueCase, String initialValue) {
        List<StringReplacement> useReplacements = this.getActiveReplacements();
        if (useReplacements == null || useReplacements.isEmpty()) {
            this.getLogger().trace("    String {} {}: {} (no-active replacements, unchanged)", new Object[]{inputName, valueCase, initialValue});
            return null;
        }
        return this.updateString(inputName, valueCase, initialValue, useReplacements);
    }

    protected String updateString(String inputName, String valueCase, String initialValue, List<StringReplacement> replacements) {
        Logger useLogger = this.getLogger();
        if (initialValue == null || initialValue.isEmpty()) {
            useLogger.trace("    String {} {}: {} (empty, unchanged)", new Object[]{inputName, valueCase, initialValue});
            return null;
        }
        boolean allowMultiple = this.allowMultipleReplacements();
        ArrayList<String> cases = new ArrayList<String>(allowMultiple ? replacements.size() : 1);
        String finalValue = initialValue;
        for (StringReplacement replacement : replacements) {
            String priorValue;
            finalValue = replacement.apply(inputName, priorValue = finalValue, cases);
            if (finalValue == null) {
                finalValue = priorValue;
                continue;
            }
            useLogger.trace("Input [ {} ] [ {} ] Initial [ {} ] Final [ {} ] ( {} )", new Object[]{inputName, valueCase, priorValue, finalValue, cases});
            if (allowMultiple) continue;
            break;
        }
        if (finalValue == initialValue) {
            useLogger.trace("    String {} {}: {} (unchanged)", new Object[]{inputName, valueCase, initialValue});
            return null;
        }
        useLogger.trace("    String {} {}: {} -> {} ({})", new Object[]{inputName, valueCase, initialValue, finalValue, cases});
        return finalValue;
    }

    protected String packagesUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().replacePackages(initialValue);
        if (finalValue != null) {
            cases.add("packages");
        }
        return finalValue;
    }

    protected String binaryPackagesUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().replaceBinaryPackages(initialValue);
        if (finalValue != null) {
            cases.add("binary packages");
        }
        return finalValue;
    }

    protected String textUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().replaceText(inputName, initialValue);
        if (finalValue != null) {
            cases.add("text");
        }
        return finalValue;
    }

    protected String directPerClassUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().replaceTextDirectPerClass(initialValue, inputName);
        if (finalValue != null) {
            cases.add("direct per class");
        }
        return finalValue;
    }

    protected String directPerClassUpdate_java(String inputName, String initialValue, List<String> cases) {
        String lookupName = this.switchExtensionTo(inputName, ".java", ".class");
        if (lookupName == null) {
            return null;
        }
        String finalValue = this.getSignatureRule().replaceTextDirectPerClass(initialValue, lookupName);
        if (finalValue != null) {
            cases.add("direct per class (java)");
        }
        return finalValue;
    }

    private String switchExtensionTo(String inputName, String initialExt, String finalExtension) {
        if (!inputName.toLowerCase().endsWith(initialExt)) {
            this.getLogger().error("Input [ {} ] does not have expected extension [ {} ]", (Object)inputName, (Object)initialExt);
            return null;
        }
        String head = inputName.substring(0, inputName.length() - initialExt.length());
        return head + finalExtension;
    }

    protected String directGlobalUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().replaceTextDirectGlobal(initialValue, inputName);
        if (finalValue != null) {
            cases.add("direct global");
        }
        return finalValue;
    }

    protected String binaryTypeUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().transformBinaryType(initialValue);
        if (finalValue != null) {
            cases.add("binary type");
        }
        return finalValue;
    }

    protected String descriptorUpdate(String inputName, String initialValue, List<String> cases) {
        String finalValue = this.getSignatureRule().transformDescriptor(initialValue);
        if (finalValue != null) {
            cases.add("binary descriptor");
        }
        return finalValue;
    }

    @FunctionalInterface
    public static interface StringReplacement {
        public String apply(String var1, String var2, List<String> var3);
    }
}

