/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.action.Changes;
import org.slf4j.Logger;

public abstract class ChangesImpl
implements Changes {
    private String inputResourceName;
    private String outputResourceName;

    @Override
    public abstract boolean isContentChanged();

    public abstract String toString();

    @Override
    public boolean isChanged() {
        return this.isRenamed() || this.isContentChanged();
    }

    @Override
    public boolean isRenamed() {
        String inputResourceName = this.getInputResourceName();
        return inputResourceName != null && !inputResourceName.equals(this.getOutputResourceName());
    }

    @Override
    public String getChangeText() {
        boolean nameChanged = this.isRenamed();
        boolean contentChanged = this.isContentChanged();
        if (nameChanged && contentChanged) {
            return "Name and content changes";
        }
        if (nameChanged) {
            return "Name changes";
        }
        if (contentChanged) {
            return "Content changes";
        }
        return "No changes";
    }

    @Override
    public String getInputResourceName() {
        return this.inputResourceName;
    }

    @Override
    public ChangesImpl setInputResourceName(String inputResourceName) {
        this.inputResourceName = inputResourceName;
        return this;
    }

    @Override
    public String getOutputResourceName() {
        return this.outputResourceName;
    }

    @Override
    public ChangesImpl setOutputResourceName(String outputResourceName) {
        this.outputResourceName = outputResourceName;
        return this;
    }

    @Override
    public void log(Logger logger, String inputPath, String outputPath) {
        if (logger.isInfoEnabled(Transformer.consoleMarker)) {
            String useInputName = this.getInputResourceName();
            String useOutputName = this.getOutputResourceName();
            if (useInputName.equals(inputPath)) {
                logger.info(Transformer.consoleMarker, "Input  [ {} ]", (Object)inputPath);
            } else {
                logger.info(Transformer.consoleMarker, "Input  [ {} ] as [ {} ]", (Object)this.getInputResourceName(), (Object)inputPath);
            }
            if (useOutputName.equals(outputPath)) {
                logger.info(Transformer.consoleMarker, "Output [ {} ]", (Object)outputPath);
            } else {
                logger.info(Transformer.consoleMarker, "Output [ {} ] as [ {} ]", (Object)this.getOutputResourceName(), (Object)outputPath);
            }
            this.logChanges(logger);
        }
    }

    protected void logChanges(Logger logger) {
        logger.info(Transformer.consoleMarker, "Changes [ {} ]", (Object)this.getChangeText());
    }
}

