/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.File;
import java.util.function.Function;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionSelector;
import org.eclipse.transformer.action.ContainerAction;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.ActionSelectorImpl;
import org.eclipse.transformer.action.impl.ContainerChangesImpl;

public abstract class ContainerActionImpl
extends ActionImpl
implements ContainerAction {
    private final ActionSelector actionSelector;

    public ContainerActionImpl(ActionContext context, ActionSelector actionSelector) {
        super(context);
        this.actionSelector = actionSelector;
    }

    public ContainerActionImpl(ActionContext context) {
        this(context, new ActionSelectorImpl());
    }

    public <ACTION extends Action> ACTION addUsing(Function<? super ActionContext, ACTION> init) {
        return this.getActionSelector().addUsing(init, this.getContext());
    }

    @Override
    public ActionSelector getActionSelector() {
        return this.actionSelector;
    }

    @Override
    protected ContainerChangesImpl newChanges() {
        return new ContainerChangesImpl();
    }

    @Override
    public ContainerChangesImpl getActiveChanges() {
        return (ContainerChangesImpl)super.getActiveChanges();
    }

    @Override
    public ContainerChangesImpl getLastActiveChanges() {
        return (ContainerChangesImpl)super.getLastActiveChanges();
    }

    protected void recordUnaccepted(String resourceName) {
        this.getLogger().debug("Resource [ {} ]: Not accepted", (Object)resourceName);
        this.getActiveChanges().recordUnaccepted();
    }

    protected void recordUnselected(String resourceName) {
        this.getLogger().debug("Resource [ {} ]: Not selected", (Object)resourceName);
        this.getActiveChanges().recordUnselected();
    }

    protected void recordUnchanged(Action action, String resourceName) {
        this.getLogger().debug("Resource [ {} ]: Action [ {} ]: Not changed", (Object)action.getName(), (Object)resourceName);
        this.getActiveChanges().recordUnchanged(action);
    }

    protected void recordAction(Action action, String resourceName) {
        this.getLogger().debug("Resource [ {} ]: Action [ {} ]", (Object)action.getName(), (Object)resourceName);
        this.getActiveChanges().recordAction(action);
        if (action.isContainerAction()) {
            this.getActiveChanges().add(((ContainerAction)action).getLastActiveChanges());
        }
    }

    protected void recordError(Action action, String resourceName, Throwable error) {
        String actionName = action == null ? "null" : action.getName();
        this.getLogger().error("Resource [ " + resourceName + " ] Action [ " + actionName + " ]: Failed transform", error);
        this.getActiveChanges().recordFailed(action);
    }

    protected void recordDuplicate(Action action, String resourceName) {
        String actionName = action == null ? "null" : action.getName();
        this.getLogger().error("Resource [ {} ] Action [ {} ]: Duplicate", (Object)resourceName, (Object)actionName);
        this.getActiveChanges().recordDuplicated(action);
    }

    @Override
    public abstract void apply(String var1, File var2, String var3, File var4);
}

