/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.unmodifiable.Sets;
import aQute.lib.io.ByteBufferOutputStream;
import aQute.lib.manifest.ManifestUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ElementActionImpl;
import org.eclipse.transformer.util.SignatureUtils;

public class ManifestActionImpl
extends ElementActionImpl {
    private final ActionType actionType;
    private static final Set<String> SELECT_ATTRIBUTES = Sets.of((Object)"DynamicImport-Package", (Object)"Import-Package", (Object)"Export-Package", (Object)"Subsystem-Content", (Object)"IBM-API-Package", (Object)"Provide-Capability", (Object)"Require-Capability");
    public static final String SYMBOLIC_NAME_PROPERTY_NAME = "Bundle-SymbolicName";
    public static final String VERSION_PROPERTY_NAME = "Bundle-Version";
    public static final String NAME_PROPERTY_NAME = "Bundle-Name";
    public static final String DESCRIPTION_PROPERTY_NAME = "Bundle-Description";

    public ManifestActionImpl(ActionContext context, ActionType actionType) {
        super(context);
        this.actionType = actionType;
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }

    private boolean isManifest() {
        return this.getActionType() == ActionType.MANIFEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteData apply(ByteData inputData) throws TransformException {
        this.startRecording(inputData);
        try {
            Manifest initialManifest;
            String className = this.getClass().getSimpleName();
            String methodName = "apply";
            this.getLogger().debug("[ {}.{} ]: Initial [ {} ]", new Object[]{className, methodName, inputData});
            this.setResourceNames(inputData.name(), inputData.name());
            try {
                initialManifest = new Manifest(inputData.stream());
            }
            catch (IOException e) {
                throw new TransformException("Failed to parse manifest [ " + inputData.name() + " ]", e);
            }
            Manifest finalManifest = new Manifest();
            this.transform(inputData.name(), initialManifest, finalManifest);
            if (!this.isChanged()) {
                this.getLogger().debug("[ {}.{} ]: [ {} ] Null transform", new Object[]{className, methodName, inputData.name()});
                ByteData byteData = inputData;
                return byteData;
            }
            Charset charset = inputData.charset();
            ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputData.length());
            try {
                this.write(finalManifest, (OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new TransformException("Failed to write manifest [ " + inputData.name() + " ]", e);
            }
            ByteDataImpl outputData = new ByteDataImpl(inputData.name(), outputStream.toByteBuffer(), charset);
            this.getLogger().debug("[ {}.{} ]: Final [ {} ]", new Object[]{className, methodName, outputData});
            ByteDataImpl byteDataImpl = outputData;
            return byteDataImpl;
        }
        finally {
            this.stopRecording(inputData);
        }
    }

    protected void transform(String inputName, Manifest initialManifest, Manifest finalManifest) {
        Attributes initialMainAttributes = initialManifest.getMainAttributes();
        Attributes finalMainAttributes = finalManifest.getMainAttributes();
        this.addReplacements(this.transformPackages(inputName, "main", initialMainAttributes, finalMainAttributes));
        if (this.transformBundleIdentity(inputName, initialMainAttributes, finalMainAttributes)) {
            this.addReplacement();
        }
        Map<String, Attributes> initialEntries = initialManifest.getEntries();
        Map<String, Attributes> finalEntries = finalManifest.getEntries();
        for (Map.Entry<String, Attributes> entry : initialEntries.entrySet()) {
            String entryKey = entry.getKey();
            Attributes initialEntryAttributes = entry.getValue();
            Attributes finalAttributes = new Attributes(initialEntryAttributes.size());
            finalEntries.put(entryKey, finalAttributes);
            this.addReplacements(this.transformPackages(inputName, entryKey, initialEntryAttributes, finalAttributes));
        }
    }

    public static Set<String> getSelectedAttributes() {
        return SELECT_ATTRIBUTES;
    }

    public static boolean selectAttribute(String name) {
        return SELECT_ATTRIBUTES.contains(name);
    }

    protected int transformPackages(String inputName, String entryName, Attributes initialAttributes, Attributes finalAttributes) {
        this.getLogger().trace("Transforming [ {} ]: [ {} ] Attributes [ {} ]", new Object[]{inputName, entryName, initialAttributes.size()});
        int replacements = 0;
        for (Map.Entry<Object, Object> entries : initialAttributes.entrySet()) {
            Object untypedName = entries.getKey();
            String typedName = untypedName.toString();
            String initialValue = (String)entries.getValue();
            String finalValue = null;
            if (ManifestActionImpl.selectAttribute(typedName)) {
                finalValue = this.replacePackages(typedName, initialValue);
            }
            if (finalValue == null) {
                finalValue = initialValue;
            } else {
                ++replacements;
            }
            finalAttributes.put(untypedName, finalValue);
        }
        this.getLogger().trace("Transformed [ {} ]: [ {} ] Attributes [ {} ] Replacements [ {} ]", new Object[]{inputName, entryName, finalAttributes.size(), replacements});
        return replacements;
    }

    protected void write(Manifest manifest, OutputStream outputStream) throws IOException {
        if (this.isManifest()) {
            this.writeAsManifest(manifest, outputStream);
        } else {
            this.writeAsFeature(manifest, outputStream);
        }
    }

    protected void writeAsManifest(Manifest manifest, OutputStream outputStream) throws IOException {
        ManifestUtil.write((Manifest)manifest, (OutputStream)outputStream);
    }

    protected void writeAsFeature(Manifest manifest, OutputStream outputStream) throws IOException {
        PrintWriter writer = new PrintWriter(outputStream);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> mainEntry : manifest.getMainAttributes().entrySet()) {
            writer.append(mainEntry.getKey().toString());
            writer.append(": ");
            String value = (String)mainEntry.getValue();
            if (value.indexOf(44) == -1) {
                writer.append(value);
            } else {
                Parameters parms = OSGiHeader.parseHeader((String)value);
                boolean continuedLine = false;
                for (Map.Entry parmEntry : parms.entrySet()) {
                    String parmName;
                    int index;
                    if (continuedLine) {
                        writer.append(",\r ");
                    }
                    if ((index = (parmName = (String)parmEntry.getKey()).indexOf(126)) != -1) {
                        parmName = parmName.substring(0, index);
                    }
                    writer.append(parmName);
                    Attrs parmAttrs = (Attrs)parmEntry.getValue();
                    for (Map.Entry parmAttrEntry : parmAttrs.entrySet()) {
                        String parmAttrName = (String)parmAttrEntry.getKey();
                        String parmAttrValue = this.quote(builder, (String)parmAttrEntry.getValue());
                        writer.append("; ");
                        writer.append(parmAttrName);
                        writer.append('=');
                        writer.append(parmAttrValue);
                    }
                    continuedLine = true;
                }
            }
            writer.append("\r");
        }
        writer.flush();
    }

    public String quote(StringBuilder sb, String value) {
        boolean isClean = OSGiHeader.quote((StringBuilder)sb, (String)value);
        String quotedValue = sb.toString();
        sb.setLength(0);
        return quotedValue;
    }

    protected String replacePackages(String attributeName, String text) {
        String initialText = text;
        for (Map.Entry<String, String> renameEntry : this.getPackageRenames().entrySet()) {
            int matchStart;
            String key = renameEntry.getKey();
            boolean matchPackageStem = SignatureUtils.containsWildcard(key);
            if (matchPackageStem) {
                key = SignatureUtils.stripWildcard(key);
            }
            int keyLen = key.length();
            int textLimit = text.length() - keyLen;
            int matchEnd = 0;
            while (matchEnd <= textLimit && (matchStart = text.indexOf(key, matchEnd)) != -1) {
                matchEnd = matchStart + keyLen;
                int packageEnd = SignatureUtils.packageMatch(text, matchStart, matchEnd, matchPackageStem);
                if (packageEnd == -1) continue;
                String value = renameEntry.getValue();
                if (matchEnd < packageEnd) {
                    value = value.concat(text.substring(matchEnd, packageEnd));
                }
                String head = text.substring(0, matchStart);
                String tail = text.substring(packageEnd);
                String newVersion = this.replacePackageVersion(attributeName, value, tail);
                if (newVersion != null) {
                    tail = this.replacePackageVersion(tail, newVersion);
                }
                text = head + value + tail;
                matchEnd = matchStart + value.length();
                textLimit = text.length() - keyLen;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    protected String replacePackageVersion(String text, String newVersion) {
        String packageText = this.getPackageAttributeText(text);
        if (packageText == null) {
            return text;
        }
        if (packageText.isEmpty()) {
            return text;
        }
        String VERSION = "version";
        int VERSION_LEN = 7;
        int QUOTE_MARK = 34;
        int versionIndex = packageText.indexOf("version");
        if (versionIndex == -1) {
            return text;
        }
        boolean foundEquals = false;
        boolean foundQuotationMark = false;
        int versionBeginIndex = -1;
        int versionEndIndex = -1;
        for (int i = versionIndex + 7; i < packageText.length(); ++i) {
            char ch = packageText.charAt(i);
            if (!foundEquals) {
                if (ch == '=') {
                    foundEquals = true;
                    continue;
                }
                if (Character.isWhitespace(ch)) continue;
                this.getLogger().error("Found a non-white-space character before the equals sign, in package text [ {} ]", (Object)packageText);
                return text;
            }
            if (Character.isWhitespace(ch) || foundQuotationMark) continue;
            if (ch == '\"') {
                versionBeginIndex = i + 1;
                versionEndIndex = packageText.indexOf(34, i + 1);
                if (versionEndIndex == -1) {
                    this.getLogger().error("Version does not have a closing quotation mark, in package text [ {} ]", (Object)packageText);
                    return text;
                }
                --versionEndIndex;
                foundQuotationMark = true;
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            this.getLogger().error("Found a non-white-space character after the equals sign, in package text [ {} ]", (Object)packageText);
            return text;
        }
        String head = text.substring(0, versionBeginIndex);
        String tail = text.substring(versionEndIndex + 1);
        String newText = head + newVersion + tail;
        return newText;
    }

    protected String getPackageAttributeText(String text) {
        if (text == null) {
            return null;
        }
        if (!this.firstCharIsSemicolon(text)) {
            return "";
        }
        int commaIndex = text.indexOf(44);
        if (commaIndex == -1) {
            return text;
        }
        String packageText = text.substring(0, commaIndex + 1);
        this.getLogger().trace("packageText [ {} ]", (Object)packageText);
        while (!this.isPackageDelimitingComma(text, packageText, commaIndex)) {
            commaIndex = text.indexOf(44, packageText.length());
            if (commaIndex == -1) {
                packageText = text;
                break;
            }
            packageText = text.substring(0, commaIndex + 1);
            if (this.hasEvenNumberOfOccurrencesOfChar(text, '\"')) continue;
        }
        this.getLogger().trace("getPackageAttributeText returning: [ {} ]", (Object)packageText);
        return packageText;
    }

    protected boolean firstCharIsSemicolon(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.charAt(i) == ';';
        }
        return false;
    }

    protected int indexOfNextNonWhiteSpaceChar(String s, int currentIndex) {
        for (int i = currentIndex; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean isPackageDelimitingComma(String testString, String packageText, int indexOfComma) {
        int indexOfNextNonWhiteSpaceCharAfterComma = this.indexOfNextNonWhiteSpaceChar(testString, indexOfComma + 1);
        char characterAfterComma = testString.charAt(indexOfNextNonWhiteSpaceCharAfterComma);
        if (Character.isAlphabetic(characterAfterComma)) {
            return this.hasEvenNumberOfOccurrencesOfChar(packageText, '\"');
        }
        return false;
    }

    private boolean hasEvenNumberOfOccurrencesOfChar(String testString, char testChar) {
        long occurrences = testString.chars().filter(ch -> ch == 34).count();
        return occurrences % 2L == 0L;
    }

    public boolean transformBundleIdentity(String inputName, Attributes initialMainAttributes, Attributes finalMainAttributes) {
        String finalDescription;
        String initialDescription;
        String finalName;
        String initialName;
        String finalVersion;
        String initialVersion;
        int wildcardOffset;
        String matchCase;
        boolean isWildcard;
        boolean matched;
        BundleData bundleUpdate;
        String initialSymbolicName = initialMainAttributes.getValue(SYMBOLIC_NAME_PROPERTY_NAME);
        if (initialSymbolicName == null) {
            this.getLogger().trace("Input [ {} ] has no bundle symbolic name", (Object)inputName);
            return false;
        }
        int indexOfSemiColon = initialSymbolicName.indexOf(59);
        String symbolicNamesAttributes = null;
        if (indexOfSemiColon != -1) {
            symbolicNamesAttributes = initialSymbolicName.substring(indexOfSemiColon);
            initialSymbolicName = initialSymbolicName.substring(0, indexOfSemiColon);
        }
        if ((bundleUpdate = this.getBundleUpdate(initialSymbolicName)) == null) {
            bundleUpdate = this.getBundleUpdate("*");
            if (bundleUpdate != null) {
                matched = true;
                isWildcard = true;
                matchCase = "a wildcard identity update";
            } else {
                matched = false;
                isWildcard = false;
                matchCase = "no identity update";
            }
        } else {
            matched = true;
            isWildcard = false;
            matchCase = "identity update";
        }
        this.getLogger().trace("Input [ {} ] symbolic name [ {} ] has {}", new Object[]{inputName, initialSymbolicName, matchCase});
        if (!matched) {
            return false;
        }
        String finalSymbolicName = bundleUpdate.getSymbolicName();
        if (isWildcard && (wildcardOffset = finalSymbolicName.indexOf(42)) != -1) {
            finalSymbolicName = finalSymbolicName.substring(0, wildcardOffset) + initialSymbolicName + finalSymbolicName.substring(wildcardOffset + 1);
        }
        if (symbolicNamesAttributes != null) {
            finalSymbolicName = finalSymbolicName + symbolicNamesAttributes;
        }
        finalMainAttributes.putValue(SYMBOLIC_NAME_PROPERTY_NAME, finalSymbolicName);
        this.getLogger().debug("Bundle symbolic name: {} --> {}", (Object)initialSymbolicName, (Object)finalSymbolicName);
        if (!isWildcard && (initialVersion = initialMainAttributes.getValue(VERSION_PROPERTY_NAME)) != null && (finalVersion = bundleUpdate.getVersion()) != null && !finalVersion.isEmpty()) {
            finalMainAttributes.putValue(VERSION_PROPERTY_NAME, finalVersion);
            this.getLogger().debug("Bundle version: {} --> {}", (Object)initialVersion, (Object)finalVersion);
        }
        if ((initialName = initialMainAttributes.getValue(NAME_PROPERTY_NAME)) != null && (finalName = bundleUpdate.updateName(initialName)) != null && !finalName.isEmpty()) {
            finalMainAttributes.putValue(NAME_PROPERTY_NAME, finalName);
            this.getLogger().debug("Bundle name: {} --> {}", (Object)initialName, (Object)finalName);
        }
        if ((initialDescription = initialMainAttributes.getValue(DESCRIPTION_PROPERTY_NAME)) != null && (finalDescription = bundleUpdate.updateDescription(initialDescription)) != null && !finalDescription.isEmpty()) {
            finalMainAttributes.putValue(DESCRIPTION_PROPERTY_NAME, finalDescription);
            this.getLogger().debug("Bundle description: {} --> {}", (Object)initialDescription, (Object)finalDescription);
        }
        return true;
    }
}

