/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.unmodifiable.Maps;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.transformer.action.SelectionRule;
import org.eclipse.transformer.util.FileUtils;
import org.slf4j.Logger;

public class SelectionRuleImpl
implements SelectionRule {
    private static final char RESOURCE_WILDCARD = '*';
    private final MatchSet included;
    private final MatchSet excluded;
    private final Logger logger;

    public SelectionRuleImpl(Logger logger, Map<String, String> includes, Map<String, String> excludes) {
        this.logger = logger;
        this.included = this.processSelections(includes);
        this.excluded = this.processSelections(excludes);
    }

    private MatchSet processSelections(Map<String, String> selections) {
        if (selections == null) {
            return null;
        }
        HashMap<String, Charset> exact = new HashMap<String, Charset>();
        HashMap<String, Charset> head = new HashMap<String, Charset>();
        HashMap<String, Charset> tail = new HashMap<String, Charset>();
        HashMap<String, Charset> middle = new HashMap<String, Charset>();
        Charset all = null;
        for (Map.Entry<String, String> selectionEntry : selections.entrySet()) {
            boolean matchTail;
            String selection = selectionEntry.getKey();
            int selectionLength = selection.length();
            if (selectionLength == 0) continue;
            String charsetName = selectionEntry.getValue();
            Charset charset = FileUtils.DEFAULT_CHARSET;
            if (!charsetName.isEmpty()) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warn("Invalid charset name for selection [ {} ]: \"{}\". Defaulting to {}}", new Object[]{selection, charsetName, FileUtils.DEFAULT_CHARSET, e});
                }
            }
            boolean matchHead = selection.charAt(0) == '*';
            boolean bl = matchTail = selection.charAt(selectionLength - 1) == '*';
            if (matchHead) {
                if (selectionLength == 1) {
                    all = charset;
                    continue;
                }
                if (matchTail) {
                    middle.put(selection.substring(1, selectionLength - 1), charset);
                    continue;
                }
                head.put(selection.substring(1), charset);
                continue;
            }
            if (matchTail) {
                tail.put(selection.substring(0, selectionLength - 1), charset);
                continue;
            }
            exact.put(selection, charset);
        }
        if (all == null && exact.isEmpty() && head.isEmpty() && tail.isEmpty() && middle.isEmpty()) {
            return null;
        }
        return new MatchSet(exact, head, tail, middle, all);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean select(String resourceName) {
        return this.selectIncluded(resourceName) && !this.rejectExcluded(resourceName);
    }

    @Override
    public boolean selectIncluded(String resourceName) {
        if (this.included == null) {
            this.getLogger().debug("Include [ {} ]: {}", (Object)resourceName, (Object)"*=UTF-8 (No includes)");
            return true;
        }
        Map.Entry<String, Charset> match = this.included.match(resourceName);
        if (match != null) {
            this.getLogger().debug("Include [ {} ]: {}", (Object)resourceName, match);
            return true;
        }
        this.getLogger().debug("Do not include [ {} ]", (Object)resourceName);
        return false;
    }

    @Override
    public boolean rejectExcluded(String resourceName) {
        if (this.excluded == null) {
            this.getLogger().debug("Do not exclude [ {} ]: {}", (Object)resourceName, (Object)"No excludes");
            return false;
        }
        Map.Entry<String, Charset> match = this.excluded.match(resourceName);
        if (match != null) {
            this.getLogger().debug("Exclude [ {} ]: {}", (Object)resourceName, (Object)match.getKey());
            return true;
        }
        this.getLogger().debug("Do not exclude [ {} ]", (Object)resourceName);
        return false;
    }

    @Override
    public Charset charset(String resourceName) {
        Map.Entry<String, Charset> match;
        if (this.included != null && (match = this.included.match(resourceName)) != null) {
            this.getLogger().trace("Charset [ {} ]: {}", (Object)resourceName, match);
            return match.getValue();
        }
        this.getLogger().trace("Charset [ {} ]: <<default>> {}", (Object)resourceName, (Object)FileUtils.DEFAULT_CHARSET);
        return FileUtils.DEFAULT_CHARSET;
    }

    static class MatchSet {
        private final Map<String, Charset> exact;
        private final Map<String, Charset> head;
        private final Map<String, Charset> tail;
        private final Map<String, Charset> middle;
        private final Charset all;

        MatchSet(Map<String, Charset> exact, Map<String, Charset> head, Map<String, Charset> tail, Map<String, Charset> middle, Charset all) {
            this.exact = Maps.copyOf(exact);
            this.head = Maps.copyOf(head);
            this.tail = Maps.copyOf(tail);
            this.middle = Maps.copyOf(middle);
            this.all = all;
        }

        Map.Entry<String, Charset> match(String resourceName) {
            Charset charset = this.exact.get(resourceName);
            if (charset != null) {
                return Maps.entry((Object)resourceName, (Object)charset);
            }
            for (Map.Entry<String, Charset> entry : this.head.entrySet()) {
                if (!resourceName.endsWith(entry.getKey())) continue;
                return entry;
            }
            for (Map.Entry<String, Charset> entry : this.tail.entrySet()) {
                if (!resourceName.startsWith(entry.getKey())) continue;
                return entry;
            }
            for (Map.Entry<String, Charset> entry : this.middle.entrySet()) {
                if (!resourceName.contains(entry.getKey())) continue;
                return entry;
            }
            if (this.all != null) {
                return Maps.entry((Object)"*", (Object)this.all);
            }
            return null;
        }
    }
}

