/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ElementActionImpl;
import org.eclipse.transformer.util.FileUtils;
import org.eclipse.transformer.util.LineSeparatorBufferedReader;

public class TextActionImpl
extends ElementActionImpl {
    private final List<ActionImpl.StringReplacement> activeReplacements;

    public TextActionImpl(ActionContext context) {
        super(context);
        List<ActionImpl.StringReplacement> replacements = this.createActiveReplacements(this.getSignatureRule());
        this.activeReplacements = replacements.isEmpty() ? NO_ACTIVE_REPLACEMENTS : replacements;
    }

    @Override
    protected List<ActionImpl.StringReplacement> getActiveReplacements() {
        return this.activeReplacements;
    }

    protected List<ActionImpl.StringReplacement> createActiveReplacements(SignatureRule signatureRule) {
        ArrayList<ActionImpl.StringReplacement> replacements = new ArrayList<ActionImpl.StringReplacement>();
        if (signatureRule.hasTextUpdates()) {
            replacements.add(this::textUpdate);
        }
        return replacements;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.TEXT;
    }

    @Override
    public boolean acceptResource(String resourceName, File resourceFile) {
        return this.getTextSubstitutions(resourceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteData apply(ByteData inputData) throws TransformException {
        String inputName = inputData.name();
        this.startRecording(inputName);
        try {
            ByteData byteData;
            String outputName = this.relocateResource(inputName);
            this.setResourceNames(inputName, outputName);
            ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputData.length());
            Charset charset = inputData.charset();
            try (LineSeparatorBufferedReader reader = new LineSeparatorBufferedReader(inputData.reader());
                 BufferedWriter writer = FileUtils.writer((OutputStream)outputStream, charset);){
                this.transform(inputName, reader, writer);
            }
            catch (IOException e) {
                throw new TransformException("Failed to transform [ " + inputName + " ]", e);
            }
            if (!this.isChanged()) {
                byteData = inputData;
                return byteData;
            }
            if (!this.isContentChanged()) {
                byteData = inputData.copy(outputName);
                return byteData;
            }
            byteData = new ByteDataImpl(outputName, outputStream.toByteBuffer(), charset);
            return byteData;
        }
        finally {
            this.stopRecording(inputName);
        }
    }

    protected void transform(String inputName, LineSeparatorBufferedReader reader, BufferedWriter writer) throws IOException {
        String inputLine;
        while ((inputLine = reader.readLine()) != null) {
            String outputLine = this.transformString(inputName, "text line", inputLine);
            if (outputLine != null) {
                this.addReplacement();
            } else {
                outputLine = inputLine;
            }
            writer.write(outputLine);
            writer.write(reader.lineSeparator());
        }
    }

    protected String transformString(String inputName, String inputCase, String initialValue) {
        return this.updateString(inputName, inputCase, initialValue);
    }
}

